/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.MapSql;
import org.teasoft.bee.osql.api.MapSuid;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MapSqlProcessor;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public class MapSuidImpl
extends AbstractCommOperate
implements MapSuid {
    private BeeSql beeSql;

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> selectString(MapSql mapSql) {
        List list = null;
        try {
            this.doBeforePasreEntity(SuidType.SELECT);
            String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, select List<String[]> SQL: ", sql);
            list = this.getBeeSql().select(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectJson(MapSql mapSql) {
        String json = "";
        try {
            this.doBeforePasreEntity(SuidType.SELECT);
            String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, selectJson SQL: ", sql);
            json = this.getBeeSql().selectJson(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(MapSql mapSql) {
        List list = null;
        try {
            this.doBeforePasreEntity(SuidType.SELECT);
            String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, select List<Map> SQL: ", sql);
            list = this.getBeeSql().selectMapList(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(MapSql mapSql) {
        String total = null;
        try {
            this.doBeforePasreEntity(SuidType.SELECT);
            String sql = MapSqlProcessor.toCountSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, count SQL: ", sql);
            total = this.getBeeSql().selectFun(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return StringUtils.isBlank(total) ? 0 : Integer.parseInt(total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> selectOne(MapSql mapSql) {
        List list = null;
        try {
            this.doBeforePasreEntity(SuidType.SELECT);
            String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, selectOne Map SQL: ", sql);
            list = this.getBeeSql().selectMapList(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        if (ObjectUtils.isNotEmpty(list)) {
            return (Map)list.get(0);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(MapSql mapSql) {
        if (mapSql == null) {
            return -1;
        }
        int insertNum = 0;
        try {
            this.doBeforePasreEntity(SuidType.INSERT);
            String sql = MapSqlProcessor.toInsertSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, insert SQL: ", sql);
            insertNum = this.getBeeSql().modify(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return insertNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertAndReturnId(MapSql mapSql) {
        if (mapSql == null) {
            return -1L;
        }
        long newId = 0L;
        try {
            this.doBeforePasreEntity(SuidType.INSERT);
            String sql = MapSqlProcessor.toInsertSqlByMap(mapSql, true);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, insertAndReturnId SQL: ", sql);
            Object obj = OneTimeParameter.getAttribute("_SYS_Bee_MapSuid_Insert_Has_ID");
            if (obj != null) {
                newId = Long.parseLong(obj.toString());
                if (newId > 1L) {
                    OneTimeParameter.getAttribute("_SYS_Bee_PK_Column_For_InsertAndReturnId");
                    int insertNum = this.getBeeSql().modify(sql);
                    if (insertNum == 1) {
                        long l = newId;
                        return l;
                    }
                    long l = insertNum;
                    return l;
                }
                if (HoneyUtil.isOracle()) {
                    Logger.debug("Need create Sequence and Trigger for auto increment id. By the way,maybe use distribute id is better!");
                }
            }
            newId = this.getBeeSql().insertAndReturnId(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(MapSql mapSql) {
        int a = 0;
        try {
            this.doBeforePasreEntity(SuidType.DELETE);
            String sql = MapSqlProcessor.toDeleteSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, delete SQL: ", sql);
            a = this.getBeeSql().modify(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(MapSql mapSql) {
        int a = 0;
        try {
            this.doBeforePasreEntity(SuidType.UPDATE);
            String sql = MapSqlProcessor.toUpdateSqlByMap(mapSql);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("In MapSuid, update SQL: ", sql);
            a = this.getBeeSql().modify(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return a;
    }

    private void doBeforePasreEntity(SuidType suidType) {
        Object entity = null;
        super.doBeforePasreEntity((Object)entity, suidType);
    }
}

