/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.mongodb.MongodbBeeSql;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.Suid;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MongodbObjSQLRich;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.util.StringUtils;

public class MongodbObjSQL
extends AbstractCommOperate
implements Suid {
    private MongodbBeeSql mongodbBeeSql;

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this.checkPackage(entity);
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            list = this.getMongodbBeeSql().select(entity);
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int update(T entity) {
        if (entity == null) {
            return 0;
        }
        try {
            int updateNum;
            this.doBeforePasreEntity(entity, SuidType.UPDATE);
            int n = updateNum = this.getMongodbBeeSql().update(entity);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int insert(T entity) {
        if (entity == null) {
            return -1;
        }
        if (ShardingUtil.isSharding()) {
            Object[] array = new Object[]{entity};
            return new MongodbObjSQLRich().insert(array);
        }
        try {
            _ObjectToSQLHelper.setInitIdByAuto(entity);
            this.doBeforePasreEntity(entity, SuidType.INSERT);
            int insertNum = 0;
            insertNum = this.getMongodbBeeSql().insert(entity);
            HoneyUtil.revertId(entity);
            int n = insertNum;
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> long insertAndReturnId(T entity) {
        if (entity == null) {
            return -1L;
        }
        this.checkShardingSupport();
        try {
            _ObjectToSQLHelper.setInitIdByAuto(entity);
            this.doBeforePasreEntity(entity, SuidType.INSERT);
            long insertNum = 0L;
            insertNum = this.getMongodbBeeSql().insertAndReturnId(entity, null);
            HoneyUtil.revertId(entity);
            long l = insertNum;
            return l;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Object entity) {
        if (entity == null) {
            return -1;
        }
        try {
            this.doBeforePasreEntity(entity, SuidType.DELETE);
            int deleteNum = 0;
            int n = deleteNum = this.getMongodbBeeSql().delete(entity);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this.regCondition(condition);
            this.doBeforePasreEntity(entity, SuidType.SELECT);
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
            }
            if (condition != null) {
                ConditionImpl conditionImpl = (ConditionImpl)condition;
                String[] selectFields = conditionImpl.getSelectField();
                if (selectFields != null && selectFields.length == 1 && StringUtils.isNotBlank(selectFields[0])) {
                    selectFields = selectFields[0].split(",");
                } else if (condition.getSelectField() == null) {
                    condition.selectField(new String[]{HoneyUtil.getColumnNames(entity)});
                    HoneyContext.setTrueInSysCommStrLocal("_SYS_Bee_MongoDB_select_all_fields");
                }
            }
            list = this.getMongodbBeeSql().select(entity, condition);
        }
        catch (Throwable throwable) {
            HoneyContext.removeSysCommStrLocal("_SYS_Bee_MongoDB_select_all_fields");
            this.doBeforeReturn(list);
            throw throwable;
        }
        HoneyContext.removeSysCommStrLocal("_SYS_Bee_MongoDB_select_all_fields");
        this.doBeforeReturn(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int delete(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        try {
            this.regCondition(condition);
            this.doBeforePasreEntity(entity, SuidType.DELETE);
            int deleteNum = 0;
            int n = deleteNum = this.getMongodbBeeSql().delete(entity);
            return n;
        }
        finally {
            this.doBeforeReturn();
        }
    }

    public Suid setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    public void beginSameConnection() {
        OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_BEGIN");
        if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_EXCEPTION")) {
            Logger.warn("Last SameConnection do not have endSameConnection() or do not run endSameConnection() after having exception.");
        }
    }

    public void endSameConnection() {
        HoneyContext.endSameConnection();
    }

    private <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    public MongodbBeeSql getMongodbBeeSql() {
        if (this.mongodbBeeSql == null) {
            return BeeFactory.getHoneyFactory().getMongodbBeeSql();
        }
        return this.mongodbBeeSql;
    }

    public void setMongodbBeeSql(MongodbBeeSql mongodbBeeSql) {
        this.mongodbBeeSql = mongodbBeeSql;
    }

    private void checkShardingSupport() {
        if (ShardingUtil.isSharding()) {
            Logger.warn("Please notice this method do not support Sharding funtion by default! But you can use HintManager set the sharding table and dataSource name.");
        }
    }
}

