/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.api.MoreTable;
import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.honey.osql.core.AbstractCommOperate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableModifyStruct;
import org.teasoft.honey.osql.core.MoreTableModifyUtils;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.shortcut.BF;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.sharding.ShardingReg;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public class MoreObjSQL
extends AbstractCommOperate
implements MoreTable {
    private BeeSql beeSql;
    private MoreObjToSQL moreObjToSQL;
    private static final String SELECT_SQL = "select SQL: ";
    private static final String SELECT_JSON_SQL = "selectJson SQL: ";
    private SuidRich suidRich;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this._doBeforePasreEntity(entity);
            String sql = this.getMoreObjToSQL().toSelectSQL(entity);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL(SELECT_SQL, sql);
            list = this.getBeeSql().moreTableSelect(sql, entity);
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need >0 .");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need >=0 .");
        }
        List list = null;
        try {
            this._doBeforePasreEntity(entity);
            String sql = this.getMoreObjToSQL().toSelectSQL(entity, start, size);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL(SELECT_SQL, sql);
            list = this.getBeeSql().moreTableSelect(sql, entity);
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this.regCondition(condition);
            this._doBeforePasreEntity(entity);
            OneTimeParameter.setTrueForKey("_SYS_Bee_Check_Group_ForSharding");
            String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL(SELECT_SQL, sql);
            list = this.getBeeSql().moreTableSelect(sql, entity);
        }
        catch (Throwable throwable) {
            this.doBeforeReturn(list);
            throw throwable;
        }
        this.doBeforeReturn(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> String selectWithFun(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        String fun = null;
        try {
            ConditionImpl conditionImpl = (ConditionImpl)condition;
            List<ConditionImpl.FunExpress> funExpList = conditionImpl.getFunExpList();
            if (ObjectUtils.isEmpty(funExpList)) {
                throw new BeeIllegalSQLException("In selectWithFun, the aggregation function can not be empty!");
            }
            if (funExpList.size() > 1) {
                throw new BeeIllegalSQLException("In selectWithFun, just support one aggregation function!");
            }
            this.regCondition(condition);
            this._doBeforePasreEntity(entity);
            this._regEntityClass1(entity);
            this._regFunType(MoreObjSQL.getFunctionType(funExpList.get(0).getFunctionType()));
            String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
            sql = this.doAfterCompleteSql(sql);
            fun = this.getBeeSql().selectFun(sql);
            Logger.logSQL(SELECT_SQL, sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return fun;
    }

    private static FunctionType getFunctionType(String functionName) {
        for (FunctionType type : FunctionType.values()) {
            if (!type.getName().equalsIgnoreCase(functionName)) continue;
            return type;
        }
        return null;
    }

    private <T> void _regEntityClass1(T entity) {
        if (entity == null) {
            return;
        }
        HoneyContext.regEntityClass(entity.getClass());
    }

    private <T> void _regFunType(FunctionType functionType) {
        HoneyContext.regFunType(functionType);
    }

    public <T> int count(T entity) {
        return this.count(entity, null);
    }

    public <T> int count(T entity, Condition condition) {
        Condition con = condition == null ? BF.getCondition() : condition;
        String total = this.selectWithFun(entity, con.selectFun(FunctionType.COUNT, "*"));
        return StringUtils.isBlank(total) ? 0 : Integer.parseInt(total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<String[]> selectString(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        List list = null;
        try {
            this.regCondition(condition);
            this._doBeforePasreEntity(entity);
            this._regEntityClass1(entity);
            OneTimeParameter.setTrueForKey("_SYS_Bee_Check_Group_ForSharding");
            String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL("select SQL(return List<String[]>): ", sql);
            list = this.getBeeSql().select(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> String selectJson(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        String json = null;
        try {
            this.regCondition(condition);
            this._doBeforePasreEntity(entity);
            this._regEntityClass1(entity);
            OneTimeParameter.setTrueForKey("_SYS_Bee_Check_Group_ForSharding");
            String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
            sql = this.doAfterCompleteSql(sql);
            Logger.logSQL(SELECT_JSON_SQL, sql);
            json = this.getBeeSql().selectJson(sql);
        }
        finally {
            this.doBeforeReturn();
        }
        return json;
    }

    public MoreObjSQL setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    private void _doBeforePasreEntity(Object entity) {
        ShardingReg.setTrue("_SYS_Bee_MoreTableSelectShardingFlag");
        super.doBeforePasreEntity(entity, SuidType.SELECT);
        OneTimeParameter.setAttribute("_SYS_Bee_InterceptorChainForMoreTable", this.getInterceptorChain());
    }

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return BeeFactory.getHoneyFactory().getMoreObjToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }

    public SuidRich getSuidRich() {
        if (this.suidRich == null) {
            this.suidRich = BeeFactory.getHoneyFactory().getSuidRich();
        }
        return this.suidRich;
    }

    public void setSuidRich(SuidRich suidRich) {
        this.suidRich = suidRich;
    }

    public <T> int insert(T entity) {
        return this.modify(entity, SuidType.INSERT);
    }

    public <T> int update(T entity) {
        return this.modify(entity, SuidType.UPDATE);
    }

    public <T> int delete(T entity) {
        return this.modify(entity, SuidType.DELETE);
    }

    private <T> int modify(T entity, SuidType suidType) {
        Object idValeu;
        MoreTableModifyStruct struct = null;
        boolean hasParseEntity = false;
        boolean hasProcess = false;
        long updateNum = 0L;
        if (suidType == SuidType.UPDATE && (idValeu = HoneyUtil.getIdValue(entity)) == null) {
            struct = MoreTableModifyUtils._getMoreTableModifyStruct(entity);
            hasParseEntity = true;
            boolean nullKeyValue = false;
            if (struct.ref.length == 1) {
                nullKeyValue = this.checkTempKeyNullValue(entity, struct.ref[0]);
                updateNum = this.getSuidRich().updateBy(entity, struct.ref[0]);
                hasProcess = true;
            } else if (struct.ref.length == 2) {
                String[] tempKey = this.mergeArrays(struct.ref[0], struct.ref[1]);
                nullKeyValue = this.checkTempKeyNullValue(entity, tempKey);
                updateNum = this.getSuidRich().updateBy(entity, tempKey);
                hasProcess = true;
            }
            if (nullKeyValue) {
                return (int)updateNum;
            }
        }
        if (!hasParseEntity && suidType == SuidType.INSERT) {
            struct = MoreTableModifyUtils._getMoreTableModifyStruct(entity);
            if (struct == null) {
                Logger.warn("Please confirm whether use @FK annotation!");
            } else {
                hasParseEntity = true;
                boolean processJustMainInsert = false;
                int len0 = struct.subField.length;
                if (len0 == 0 || len0 > 0 && struct.subField[0] == null) {
                    processJustMainInsert = true;
                } else {
                    try {
                        if (struct.subIsList[0]) {
                            HoneyUtil.setAccessibleTrue(struct.subField[0]);
                            List listSubI = (List)struct.subField[0].get(entity);
                            if (ObjectUtils.isEmpty(listSubI)) {
                                processJustMainInsert = true;
                            }
                        } else {
                            HoneyUtil.setAccessibleTrue(struct.subField[0]);
                            Object subEntity = struct.subField[0].get(entity);
                            if (subEntity == null) {
                                processJustMainInsert = true;
                            }
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw ExceptionHelper.convert(e);
                    }
                    if (processJustMainInsert) {
                        int affectNum = this.getSuidRich().insert(entity);
                        hasProcess = true;
                        return affectNum;
                    }
                }
            }
        }
        long returnId = 0L;
        if (!hasProcess) {
            returnId = this.modifyOneEntity(entity, suidType);
        }
        if (returnId < 0L || suidType != SuidType.UPDATE && returnId == 0L) {
            return (int)returnId;
        }
        if (!hasParseEntity) {
            struct = MoreTableModifyUtils._getMoreTableModifyStruct(entity);
        }
        if (struct != null) {
            int len = struct.subField.length;
            try {
                for (int k = 0; k < len; ++k) {
                    if (k == 0 && struct.oneHasOne) {
                        OneHasOne t = this.moreSubModify(struct, k, returnId, entity, suidType);
                        if (t != null) {
                            ++k;
                            this.moreSubModify(struct, 1, t.returnId1, t.subEntity, suidType);
                            continue;
                        }
                        if (SuidType.DELETE != suidType && SuidType.UPDATE != suidType) continue;
                        ++k;
                        continue;
                    }
                    this.moreSubModify(struct, k, returnId, entity, suidType);
                }
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
            catch (NoSuchFieldException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        if (SuidType.INSERT == suidType) {
            return 1;
        }
        return (int)returnId;
    }

    private OneHasOne moreSubModify(MoreTableModifyStruct struct, int i, long returnId, Object currentEntity, SuidType suidType) throws IllegalAccessException, NoSuchFieldException {
        if (struct.subIsList[i]) {
            HoneyUtil.setAccessibleTrue(struct.subField[i]);
            List listSubI = (List)struct.subField[i].get(currentEntity);
            if (ObjectUtils.isEmpty(listSubI)) {
                return null;
            }
            boolean setFlag = false;
            for (Object item : listSubI) {
                if (item == null) continue;
                for (int propIndex = 0; propIndex < struct.foreignKey[i].length; ++propIndex) {
                    Field fkField = HoneyUtil.getField(item.getClass(), struct.foreignKey[i][propIndex]);
                    setFlag = SuidType.INSERT == suidType ? this.setPkField(struct, i, returnId, currentEntity, item, fkField, propIndex) : this.setPkField2(struct, i, returnId, currentEntity, item, fkField, propIndex);
                }
                if (!setFlag) continue;
                if (SuidType.DELETE == suidType) {
                    this.getSuidRich().delete(listSubI.get(i));
                    continue;
                }
                if (SuidType.UPDATE != suidType) continue;
                Object idValeu = HoneyUtil.getIdValue(listSubI.get(i));
                if (idValeu != null) {
                    this.getSuidRich().update(listSubI.get(i));
                    continue;
                }
                this.getSuidRich().updateBy(listSubI.get(i), struct.foreignKey[i]);
            }
            if (SuidType.INSERT == suidType) {
                this.getSuidRich().insert(listSubI);
            }
        } else {
            long returnId1;
            if (struct.subField[i] == null) {
                return null;
            }
            HoneyUtil.setAccessibleTrue(struct.subField[i]);
            Object subEntity = struct.subField[i].get(currentEntity);
            if (subEntity == null) {
                return null;
            }
            for (int propIndex = 0; propIndex < struct.foreignKey[i].length; ++propIndex) {
                Field f = HoneyUtil.getField(subEntity.getClass(), struct.foreignKey[i][propIndex]);
                boolean setFlag = SuidType.INSERT == suidType ? this.setPkField(struct, i, returnId, currentEntity, subEntity, f, propIndex) : this.setPkField2(struct, i, returnId, currentEntity, subEntity, f, propIndex);
                if (setFlag || SuidType.INSERT == suidType) continue;
                return null;
            }
            boolean needReturn = false;
            if (SuidType.UPDATE == suidType) {
                Object idValeu = HoneyUtil.getIdValue(subEntity);
                returnId1 = idValeu != null ? (long)this.getSuidRich().update(subEntity) : (long)this.getSuidRich().updateBy(subEntity, struct.foreignKey[i]);
                if (returnId1 >= 0L) {
                    needReturn = true;
                }
            } else {
                returnId1 = this.modifyOneEntity(subEntity, suidType);
                if (returnId1 > 0L) {
                    needReturn = true;
                }
            }
            if (i == 0 && needReturn && struct.oneHasOne) {
                OneHasOne t = new OneHasOne();
                t.returnId1 = returnId1;
                t.subEntity = subEntity;
                return t;
            }
        }
        return null;
    }

    private <T> boolean checkTempKeyNullValue(T entity, String[] tempKey) {
        Field field = null;
        boolean nullKeyValue = true;
        try {
            for (int i = 0; i < tempKey.length; ++i) {
                field = HoneyUtil.getField(entity.getClass(), tempKey[i]);
                Object obj = null;
                try {
                    if (field == null) continue;
                    HoneyUtil.setAccessibleTrue(field);
                    obj = field.get(entity);
                    if (obj == null) {
                        Logger.warn("The " + field.getName() + " value is null!");
                        nullKeyValue = nullKeyValue;
                        continue;
                    }
                    nullKeyValue = false;
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw ExceptionHelper.convert(e);
                }
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
        }
        return nullKeyValue;
    }

    private boolean setPkField(MoreTableModifyStruct struct, int i, long returnId, Object currentEntity, Object subEntity, Field fkField, int propIndex) throws IllegalAccessException, NoSuchFieldException {
        boolean useReturnId = false;
        if ("id".equalsIgnoreCase(struct.ref[i][propIndex])) {
            useReturnId = true;
        } else {
            Field refField = HoneyUtil.getField(currentEntity.getClass(), struct.ref[i][propIndex]);
            if (AnnoUtil.isPrimaryKey(refField)) {
                useReturnId = true;
            } else {
                HoneyUtil.setAccessibleTrue(fkField);
                HoneyUtil.setAccessibleTrue(refField);
                MoreObjSQL.setFieldValue(fkField, subEntity, refField.get(currentEntity));
            }
        }
        if (useReturnId) {
            HoneyUtil.setAccessibleTrue(fkField);
            MoreObjSQL.setFieldValue(fkField, subEntity, returnId);
        }
        return true;
    }

    private boolean setPkField2(MoreTableModifyStruct struct, int i, long returnId, Object currentEntity, Object subEntity, Field fkField, int propIndex) throws IllegalAccessException, NoSuchFieldException {
        Field refField = HoneyUtil.getField(currentEntity.getClass(), struct.ref[i][propIndex]);
        HoneyUtil.setAccessibleTrue(fkField);
        HoneyUtil.setAccessibleTrue(refField);
        Object v = refField.get(currentEntity);
        if (v == null) {
            Object v2 = fkField.get(subEntity);
            if (v2 == null) {
                return false;
            }
        } else {
            MoreObjSQL.setFieldValue(fkField, subEntity, v);
        }
        return true;
    }

    private <T> long modifyOneEntity(T entity, SuidType suidType) {
        long returnId = 0L;
        if (SuidType.INSERT == suidType) {
            returnId = this.getSuidRich().insertAndReturnId(entity);
        } else if (SuidType.UPDATE == suidType) {
            returnId = this.getSuidRich().update(entity);
        } else if (SuidType.DELETE == suidType) {
            returnId = this.getSuidRich().delete(entity);
        }
        return returnId;
    }

    private String[] mergeArrays(String[] array1, String[] array2) {
        if (array2 == null || array2.length == 0) {
            return array1;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : array1) {
            set.add(s);
        }
        for (String s : array2) {
            set.add(s);
        }
        String[] r = new String[set.size()];
        int i = 0;
        for (String str : set) {
            r[i++] = str;
        }
        return r;
    }

    public static void setFieldValue(Field field, Object targetObj, Object value) throws IllegalAccessException {
        if (value != null) {
            if (field.getType() == Integer.class && value.getClass() == Long.class) {
                if ((Long)value > Integer.MAX_VALUE) {
                    Logger.warn("The value " + value + "great than MAX Integer number, it maybe wrong when transfer to Ingeger number.");
                }
                value = ((Long)value).intValue();
            } else if (field.getType() == String.class && value.getClass() != String.class) {
                value = value.toString();
            }
        }
        HoneyUtil.setFieldValue(field, targetObj, value);
    }

    private class OneHasOne {
        long returnId1;
        Object subEntity;

        private OneHasOne() {
        }
    }
}

