/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.chain.UnionSelect;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.sharding.ShardingPageStruct;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SimpleRewriteSql;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.decorate.OrderBySqlDecorator;
import org.teasoft.honey.sharding.engine.decorate.PagingSqlDecorator;
import org.teasoft.honey.util.StringUtils;

public class OrderByPagingRewriteSql {
    public static List<String[]> createSqlsAndInit(String sql) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        List<String> tabNameList = HoneyContext.getListLocal("_SYS_Bee_TabNameListLocal");
        List<String> tabSuffixList = HoneyContext.getListLocal("_SYS_Bee_TabSuffixListLocal");
        Map<String, String> tab2DsMap = HoneyContext.getCustomMapLocal("_SYS_Bee_ShardingTab2DsMap");
        List<PreparedValue> listValue = HoneyContext.justGetPreparedValue(sql);
        ShardingPageStruct shardingPage = HoneyContext.getCurrentShardingPage();
        if (shardingPage == null) {
            SimpleRewriteSql._createSql(list, tabSuffixList, sql, listValue, tabNameList, tab2DsMap);
        } else {
            List<String> dsNameList = HoneyContext.getListLocal("_SYS_Bee_DsNameListLocal");
            sql = OrderByPagingRewriteSql.rewritePaingSql(sql);
            if (dsNameList.size() == 1 && !HoneyUtil.isNotSupportUnionQuery() && !ShardingUtil.isMoreTableQuery()) {
                shardingPage.setPagingType(1);
                String[] sqls = OrderByPagingRewriteSql.createShardingSql(tabSuffixList, sql);
                String newSql = OrderByPagingRewriteSql.createUnionAllSql(sqls);
                newSql = OrderBySqlDecorator.addOrderBy(newSql);
                newSql = PagingSqlDecorator.addPaging(newSql);
                ArrayList<PreparedValue> newListValue = new ArrayList<PreparedValue>();
                newListValue.addAll(listValue);
                for (int j = 1; j < sqls.length; ++j) {
                    newListValue.addAll(listValue);
                }
                HoneyContext.setPreparedValue(newSql, newListValue);
                list.add(new String[]{newSql});
                list.add(new String[]{dsNameList.get(0)});
            } else {
                Logger.warn("Involved many dataSource or not supported union all!! ");
                shardingPage.setPagingType(2);
                SimpleRewriteSql._createSql(list, tabSuffixList, sql, listValue, tabNameList, tab2DsMap);
            }
        }
        return list;
    }

    public static List<String[]> createSqlsForFullSelect(String sql, Class entityClass) {
        String baseTableName = OrderByPagingRewriteSql._toTableName(entityClass);
        List<PreparedValue> listValue = HoneyContext.justGetPreparedValue(sql);
        ShardingPageStruct shardingPage = HoneyContext.getCurrentShardingPage();
        if (shardingPage != null) {
            sql = OrderByPagingRewriteSql.rewritePaingSql(sql);
            shardingPage.setPagingType(3);
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        SimpleRewriteSql._createSqlsForFull(list, sql, listValue, baseTableName);
        return list;
    }

    private static String _toTableName(Class entityClass) {
        return NameTranslateHandle.toTableName(entityClass.getName());
    }

    private static DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    private static int firstRecordIndex() {
        return ShardingUtil.firstRecordIndex();
    }

    private static String rewritePaingSql(String sql) {
        ShardingPageStruct shardingPage = HoneyContext.getCurrentShardingPage();
        if (shardingPage == null) {
            return sql;
        }
        int start = shardingPage.getStart();
        int size = shardingPage.getSize();
        if (start != -1 && start != OrderByPagingRewriteSql.firstRecordIndex()) {
            String beforeSql = shardingPage.getBeforeSql();
            sql = OrderByPagingRewriteSql.getDbFeature().toPageSql(beforeSql, OrderByPagingRewriteSql.firstRecordIndex(), start + size - 1);
        }
        return sql;
    }

    private static String[] createShardingSql(List<String> tabSuffixList, String sql) {
        String[] sqls = new String[tabSuffixList.size()];
        for (int i = 0; i < tabSuffixList.size(); ++i) {
            sqls[i] = sql.replace("'[$#(index)#$]'", tabSuffixList.get(i));
        }
        return sqls;
    }

    private static String createUnionAllSql(String[] sqls) {
        UnionSelect unionSelect = BeeFactoryHelper.getUnionSelect();
        String newSql = unionSelect.unionAll(sqls).toSQL();
        if (StringUtils.isBlank(newSql)) {
            Logger.warn("newSql is empty!");
        }
        newSql = K.select + " * " + K.from + K.space + "(" + newSql + ") _union_select";
        return newSql;
    }
}

