/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinType;
import org.teasoft.bee.osql.api.Condition;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.interccept.InterceptorChain;
import org.teasoft.bee.sharding.GroupFunStruct;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerPagingStruct;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.sharding.ShardingReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.util.StringUtils;

public class _MoreObjectToSQLHelper {
    private static final String COMMA = ",";
    private static final String ONE_SPACE = " ";
    private static final String DOT = ".";

    private _MoreObjectToSQLHelper() {
    }

    private static DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    static <T> String _toSelectSQL(T entity) {
        return _MoreObjectToSQLHelper._toSelectSQL(entity, -1, null, -1, -1);
    }

    static <T> String _toSelectSQL(T entity, int start, int size) {
        return _MoreObjectToSQLHelper._toSelectSQL(entity, -1, null, start, size);
    }

    static <T> String _toSelectSQL(T entity, Condition condition) {
        int includeType = condition == null || condition.getIncludeType() == null ? -1 : condition.getIncludeType().getValue();
        return _MoreObjectToSQLHelper._toSelectSQL(entity, includeType, condition, -1, -1);
    }

    private static void regInterceptorSubEntity() {
        OneTimeParameter.setTrueForKey("_SYS_Bee_InterceptorSubEntity");
        ShardingReg.regMoreTableQuery();
    }

    private static <T> String _toSelectSQL(T entity, int includeType, Condition condition, int start, int size) {
        _MoreObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        Set whereFields = null;
        if (condition != null) {
            whereFields = condition.getWhereFields();
        }
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlBufferMainWhere = new StringBuffer();
        StringBuffer sqlBuffer2 = new StringBuffer();
        boolean firstWhere = true;
        try {
            String tableName = _MoreObjectToSQLHelper._toTableName(entity);
            OneTimeParameter.setAttribute("_SYS_Bee_TableName", tableName);
            OneTimeParameter.setTrueForKey("_SYS_Bee_MoreStruct_to_SqlLib");
            if (HoneyContext.isNeedRealTimeDb()) {
                HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
                OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
            }
            MoreTableStruct[] moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
            InterceptorChain chain = null;
            for (int index = 1; index <= 2; ++index) {
                if (index == 1) {
                    chain = (InterceptorChain)OneTimeParameter.getAttribute("_SYS_Bee_InterceptorChainForMoreTable");
                }
                if (moreTableStruct[index] == null) continue;
                _MoreObjectToSQLHelper.doBeforePasreSubEntity(moreTableStruct[index].subObject, chain);
            }
            boolean twoTablesWithJoinOnStyle = HoneyConfig.getHoneyConfig().moreTable_twoTablesWithJoinOnStyle;
            boolean moreTable_columnListWithStar = HoneyConfig.getHoneyConfig().moreTable_columnListWithStar;
            String columnNames = moreTableStruct[0].columnsFull;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            ArrayList<PreparedValue> mainList = new ArrayList<PreparedValue>();
            boolean needAdjustPageForList = false;
            String sqlStrForList = "";
            Integer pageSize = ConditionHelper.getPageSize(condition);
            if (!(!moreTableStruct[0].subOneIsList || ShardingUtil.hadSharding() || start == -1 && size == -1 && condition == null || start == -1 && size == -1 && pageSize == null)) {
                if (start != -1 && size != -1 && condition == null && moreTableStruct[1].subObject == null) {
                    _MoreObjectToSQLHelper.parseMainObject(entity, tableName, sqlBufferMainWhere, mainList, firstWhere, includeType);
                    Boolean idHasValue = OneTimeParameter.isTrue("idHasValue");
                    if (!idHasValue.booleanValue()) {
                        needAdjustPageForList = true;
                        StringBuffer sqlForList = new StringBuffer();
                        sqlForList.append(K.select).append(ONE_SPACE).append("*").append(ONE_SPACE).append(K.from).append(ONE_SPACE);
                        sqlForList.append(tableName);
                        sqlForList.append(sqlBufferMainWhere);
                        _MoreObjectToSQLHelper.adjustSqlServerPagingPkIfNeed(sqlStrForList, entity.getClass(), tableName);
                        sqlStrForList = _MoreObjectToSQLHelper.getDbFeature().toPageSql(sqlForList.toString(), start, size);
                        start = -1;
                        size = -1;
                    }
                } else if (start != -1 && size != -1 || pageSize != null) {
                    Logger.warn("MoreTable subTable's type is List, paging maybe not accurate!");
                }
            }
            if (condition != null) {
                int t_size;
                condition.setSuidType(SuidType.SELECT);
                boolean checkGroup = OneTimeParameter.isTrue("_SYS_Bee_Check_Group_ForSharding") && ShardingUtil.hadSharding();
                List groupNameslist = condition.getGroupByFields();
                int n = t_size = groupNameslist == null ? -1 : groupNameslist.size();
                if (checkGroup) {
                    checkGroup = checkGroup && t_size >= 1;
                }
                OneTimeParameter.setTrueForKey("_SYS_Bee_Get_GroupFunStruct");
                String selectField = ConditionHelper.processSelectField(columnNames, condition, moreTableStruct[0].subDulFieldMap);
                selectField = _MoreObjectToSQLHelper._addMaintableForSelectField(selectField, tableName);
                String fun = ConditionHelper.processFunction(columnNames, condition);
                if (selectField != null && StringUtils.isEmpty(fun)) {
                    columnNames = selectField;
                } else if (selectField != null && StringUtils.isNotEmpty(fun)) {
                    columnNames = selectField + COMMA + fun;
                } else if (selectField == null && StringUtils.isNotEmpty(fun)) {
                    columnNames = fun;
                } else if (moreTable_columnListWithStar) {
                    columnNames = "*";
                }
                if (checkGroup) {
                    Map orderByMap = condition.getOrderBy();
                    boolean isEmptyOrderByMap = orderByMap.size() == 0;
                    boolean needGroupWhenNoFun = false;
                    for (String g : groupNameslist) {
                        if (!(columnNames.contains(COMMA + g) || columnNames.contains(g + COMMA) || columnNames.equals(g))) {
                            columnNames = !g.contains(DOT) ? columnNames + COMMA + moreTableStruct[0].tableName + DOT + g : columnNames + COMMA + g;
                        }
                        if (isEmptyOrderByMap) {
                            condition.orderBy(g);
                            continue;
                        }
                        if (needGroupWhenNoFun || orderByMap.containsKey(g)) continue;
                        needGroupWhenNoFun = true;
                    }
                    GroupFunStruct gfStruct = null;
                    if (StringUtils.isNotEmpty(fun)) {
                        gfStruct = (GroupFunStruct)OneTimeParameter.getAttribute("_SYS_Bee_Return_GroupFunStruct");
                    }
                    if (gfStruct != null) {
                        gfStruct.setGroupFields(groupNameslist);
                        gfStruct.setNeedGroupWhenNoFun(needGroupWhenNoFun);
                        gfStruct.setColumnNames(columnNames);
                        HoneyContext.setCurrentGroupFunStruct(gfStruct);
                    }
                }
            } else if (moreTable_columnListWithStar) {
                columnNames = "*";
            }
            StringBuffer tableNamesForCache = new StringBuffer(tableName);
            sqlBuffer.append(K.select).append(ONE_SPACE).append(columnNames).append(ONE_SPACE).append(K.from).append(ONE_SPACE);
            if (needAdjustPageForList) {
                sqlBuffer.append("(");
                sqlBuffer.append(sqlStrForList);
                sqlBuffer.append(")");
                sqlBuffer.append(ONE_SPACE);
                list.addAll(mainList);
            }
            sqlBuffer.append(tableName);
            if (!needAdjustPageForList) {
                _MoreObjectToSQLHelper.adjustTableNameForShardingIfNeed(tableName, sqlBuffer);
            }
            String[] useSubTableNames = new String[3];
            if (condition != null) {
                OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
                ConditionHelper.processOnExpression(condition, moreTableStruct, list);
            }
            if (moreTableStruct[0].joinTableNum == 2 && StringUtils.isNotBlank(moreTableStruct[1].joinExpression) && StringUtils.isNotBlank(moreTableStruct[2].joinExpression)) {
                _MoreObjectToSQLHelper.addJoinPart(sqlBuffer, moreTableStruct[1], tableNamesForCache);
                sqlBuffer.append(ONE_SPACE);
                _MoreObjectToSQLHelper.addJoinPart(sqlBuffer, moreTableStruct[2], tableNamesForCache);
            } else if ((moreTableStruct[1].joinType != JoinType.JOIN || twoTablesWithJoinOnStyle && moreTableStruct[0].joinTableNum == 1) && StringUtils.isNotBlank(moreTableStruct[1].joinExpression)) {
                _MoreObjectToSQLHelper.addJoinPart(sqlBuffer, moreTableStruct[1], tableNamesForCache);
            } else {
                for (int s = 1; s <= 2; ++s) {
                    if (moreTableStruct[s] == null) continue;
                    useSubTableNames[s - 1] = moreTableStruct[s].useSubTableName;
                    sqlBuffer.append(COMMA);
                    sqlBuffer.append(ShardingUtil.appendTableIndexIfNeed(moreTableStruct[s].tableName));
                    tableNamesForCache.append("##").append(moreTableStruct[s].tableName);
                    if (moreTableStruct[s].hasSubAlias) {
                        sqlBuffer.append(ONE_SPACE);
                        sqlBuffer.append(moreTableStruct[s].subAlias);
                    }
                    if (!StringUtils.isNotBlank(moreTableStruct[s].joinExpression)) continue;
                    if (firstWhere) {
                        sqlBuffer2.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                        firstWhere = false;
                    } else {
                        sqlBuffer2.append(ONE_SPACE).append(K.and).append(ONE_SPACE);
                    }
                    sqlBuffer2.append(moreTableStruct[s].joinExpression);
                }
            }
            firstWhere = _MoreObjectToSQLHelper.parseMainObject(entity, tableName, sqlBuffer2, list, firstWhere, includeType);
            sqlBuffer.append(sqlBuffer2);
            for (int index = 1; index <= 2; ++index) {
                if (moreTableStruct[index] == null) continue;
                firstWhere = _MoreObjectToSQLHelper.parseSubObject(sqlBuffer, list, whereFields, firstWhere, includeType, moreTableStruct, index);
            }
            if (HoneyContext.isNeedRealTimeDb()) {
                HoneyContext.initRouteWhenParseSql(SuidType.SELECT, entity.getClass(), tableName);
                OneTimeParameter.setTrueForKey("_SYS_Bee_ALREADY_SET_ROUTE");
            }
            if (start != -1 && size != -1 && condition == null) {
                condition = BeeFactoryHelper.getCondition();
                condition.start(Integer.valueOf(start));
                condition.size(Integer.valueOf(size));
            }
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                useSubTableNames[2] = tableName;
                OneTimeParameter.setAttribute("_SYS_Bee_COLUMN_EC", entity.getClass());
                ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere, useSubTableNames);
            }
            sql = sqlBuffer.toString();
            HoneyContext.setPreparedValue(sql, list);
            _MoreObjectToSQLHelper.addInContextForCache(sql, tableNamesForCache.toString());
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private static void adjustTableNameForShardingIfNeed(String tableName, StringBuffer sqlBuffer) {
        if (ShardingUtil.useTableIndex(tableName)) {
            sqlBuffer.append("'[$#(index)#$]'");
            sqlBuffer.append(ONE_SPACE);
            sqlBuffer.append(tableName);
        }
    }

    private static void doBeforePasreSubEntity(Object subEntity, InterceptorChain chain) {
        if (subEntity != null && chain != null) {
            _MoreObjectToSQLHelper.regInterceptorSubEntity();
            chain.beforePasreEntity(subEntity, SuidType.SELECT);
        } else {
            ShardingReg.regMoreTableQuery();
        }
    }

    private static void adjustSqlServerPagingPkIfNeed(String sql, Class entityClass, String tableName) {
        if (!HoneyUtil.isSqlServer()) {
            return;
        }
        String pkName = "id";
        String pkName0 = HoneyUtil.getPkFieldNameByClass(entityClass);
        if (!"".equals(pkName0)) {
            pkName = pkName0.split(COMMA)[0];
        }
        pkName = _MoreObjectToSQLHelper._toColumnName(pkName, entityClass);
        SqlServerPagingStruct struct = new SqlServerPagingStruct();
        struct.setJustChangeOrderColumn(true);
        struct.setOrderColumn(tableName + DOT + pkName);
        HoneyContext.setSqlServerPagingStruct(sql, struct);
    }

    private static boolean parseSubObject(StringBuffer sqlBuffer2, List<PreparedValue> list, Set<String> conditionFieldSet, boolean firstWhere, int includeType, MoreTableStruct[] moreTableStruct, int index) throws IllegalAccessException {
        Object entity = moreTableStruct[index].subObject;
        if (entity == null) {
            return firstWhere;
        }
        PreparedValue preparedValue = null;
        String useSubTableName = moreTableStruct[index].useSubTableName;
        Field[] fields = null;
        fields = index == 1 && moreTableStruct[0].subOneIsList ? HoneyUtil.getFields(moreTableStruct[index].subClass) : (index == 2 && moreTableStruct[0].subTwoIsList ? HoneyUtil.getFields(moreTableStruct[index].subClass) : HoneyUtil.getFields(moreTableStruct[index].subEntityField.getType()));
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            HoneyUtil.setAccessibleTrue(fields[i]);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || _MoreObjectToSQLHelper.isNullPkOrId(fields[i], entity)) continue;
            if (firstWhere) {
                sqlBuffer2.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                firstWhere = false;
            } else {
                sqlBuffer2.append(ONE_SPACE).append(K.and).append(ONE_SPACE);
            }
            sqlBuffer2.append(useSubTableName);
            sqlBuffer2.append(DOT);
            sqlBuffer2.append(_MoreObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
            if (fields[i].get(entity) == null) {
                sqlBuffer2.append(ONE_SPACE).append(K.isNull);
                continue;
            }
            sqlBuffer2.append("=");
            sqlBuffer2.append("?");
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            if (AnnoUtil.isJson(fields[i])) {
                preparedValue.setField(fields[i]);
            }
            list.add(preparedValue);
        }
        return firstWhere;
    }

    static void addInContextForCache(String sql, String tableName) {
        CacheSuidStruct struct = new CacheSuidStruct();
        struct.setSql(sql);
        struct.setTableNames(tableName);
        HoneyContext.setCacheInfo(sql, struct);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    private static String _addMaintableForSelectField(String selectField, String mainTableName) {
        if (StringUtils.isBlank(selectField)) {
            return selectField;
        }
        String newStr = "";
        String[] str = selectField.split(COMMA);
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            if (!str[i].contains(DOT)) {
                str[i] = mainTableName + DOT + str[i].trim();
            }
            newStr = newStr + str[i];
            if (i == len - 1) continue;
            newStr = newStr + COMMA;
        }
        return newStr;
    }

    private static void addJoinPart(StringBuffer sqlBuffer, MoreTableStruct moreTableStruct, StringBuffer tableNamesForCache) {
        if (moreTableStruct.joinType == JoinType.FULL_JOIN) {
            Logger.warn("Pleae confirm the Database supports 'full join' type!");
        }
        if (HoneyUtil.isSqlKeyWordUpper()) {
            sqlBuffer.append(moreTableStruct.joinType.getType().toUpperCase());
        } else {
            sqlBuffer.append(moreTableStruct.joinType.getType());
        }
        sqlBuffer.append(moreTableStruct.tableName);
        if (ShardingUtil.useTableIndex(moreTableStruct.tableName)) {
            sqlBuffer.append("'[$#(index)#$]'");
        }
        tableNamesForCache.append("##").append(moreTableStruct.tableName);
        if (moreTableStruct.hasSubAlias) {
            sqlBuffer.append(ONE_SPACE);
            sqlBuffer.append(moreTableStruct.subAlias);
        }
        sqlBuffer.append(ONE_SPACE);
        sqlBuffer.append(K.on);
        sqlBuffer.append(ONE_SPACE);
        sqlBuffer.append(moreTableStruct.joinExpression);
        if (StringUtils.isNotBlank(moreTableStruct.onExpression)) {
            sqlBuffer.append(ONE_SPACE);
            sqlBuffer.append(K.and);
            sqlBuffer.append(ONE_SPACE);
            sqlBuffer.append(moreTableStruct.onExpression);
        }
    }

    private static <T> boolean parseMainObject(T entity, String tableName, StringBuffer sqlBuffer0, List<PreparedValue> list, boolean firstWhere, int includeType) throws IllegalAccessException {
        Field[] fields = HoneyUtil.getFields(entity.getClass());
        PreparedValue preparedValue = null;
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            HoneyUtil.setAccessibleTrue(fields[i]);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || _MoreObjectToSQLHelper.isNullPkOrId(fields[i], entity)) continue;
            if (fields[i].get(entity) != null && _MoreObjectToSQLHelper.isPrimaryKey(fields[i])) {
                OneTimeParameter.setTrueForKey("idHasValue");
            }
            if (firstWhere) {
                sqlBuffer0.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                firstWhere = false;
            } else {
                sqlBuffer0.append(ONE_SPACE).append(K.and).append(ONE_SPACE);
            }
            sqlBuffer0.append(tableName);
            sqlBuffer0.append(DOT);
            sqlBuffer0.append(_MoreObjectToSQLHelper._toColumnName(fields[i].getName(), entity.getClass()));
            if (fields[i].get(entity) == null) {
                sqlBuffer0.append(ONE_SPACE).append(K.isNull);
                continue;
            }
            sqlBuffer0.append("=");
            sqlBuffer0.append("?");
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            if (AnnoUtil.isJson(fields[i])) {
                preparedValue.setField(fields[i]);
            }
            list.add(preparedValue);
        }
        return firstWhere;
    }

    private static boolean isNullPkOrId(Field field, Object entity) {
        try {
            if (field.get(entity) == null && _MoreObjectToSQLHelper.isPrimaryKey(field)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isPrimaryKey(Field field) {
        if ("id".equalsIgnoreCase(field.getName())) {
            return true;
        }
        return AnnoUtil.isPrimaryKey(field);
    }
}

