/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.interccept.annotation;

import java.lang.reflect.Field;
import java.util.List;
import org.teasoft.bee.osql.annotation.Desensitize;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.StringUtils;

public class DesensitizeHandler {
    private DesensitizeHandler() {
    }

    public static void process(Field field, List<?> list) {
        try {
            Desensitize anno = field.getAnnotation(Desensitize.class);
            int start = anno.start();
            int end = anno.size();
            String s = anno.mask();
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                Field f = HoneyUtil.getField(obj.getClass(), field.getName());
                HoneyUtil.setAccessibleTrue(f);
                String targetStr = (String)f.get(obj);
                HoneyUtil.setFieldValue(f, obj, DesensitizeHandler.replace(targetStr, start, end, s));
            }
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
    }

    private static String replace(String targetStr, int start, int size, String mask) {
        if (StringUtils.isBlank(targetStr)) {
            return targetStr;
        }
        if (start > targetStr.length()) {
            Logger.warn("The start position exceeds the length of the string!", new Exception());
            return targetStr;
        }
        if (start < 0) {
            start = 0;
        }
        int end = start + size;
        if (size == -1) {
            end = targetStr.length();
        }
        StringBuffer b = new StringBuffer(targetStr);
        for (int i = start; i < end && i < targetStr.length(); ++i) {
            b.replace(i, i + 1, mask);
        }
        return b.toString();
    }
}

