/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.util.StringUtils;

public class DateUtil {
    private static String yyyy = "([1-2]\\d{3})";
    private static String MM = "((0[1-9])|([1][0-2]))";
    private static String dd = "(0[1-9]|[12][0-9]|30|31)";
    private static String regex1 = "^([1-2]\\d{3}-)(((0[1-9]|1[0-2])-(0[1-9]|[12][0-9]))|((0[13578]|1[02])-3[01])|((0[469]|11)-30))$";
    private static String regex2 = "^([1-2]\\d{3})(((0[1-9]|1[0-2])(0[1-9]|[12][0-9]))|((0[13578]|1[02])3[01])|((0[469]|11)30))$";

    private DateUtil() {
    }

    private static SimpleDateFormat getSimpleDateFormat() {
        SimpleDateFormat defaultFormat = null;
        String dateFormatStr = HoneyConfig.getHoneyConfig().dateFormat;
        if (dateFormatStr != null && !"".equals(dateFormatStr.trim())) {
            try {
                defaultFormat = new SimpleDateFormat(dateFormatStr);
            }
            catch (Exception e) {
                Logger.warn("In DateUtil: it is error date format String :" + dateFormatStr);
                defaultFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        } else {
            defaultFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return defaultFormat;
    }

    public static String currentDate() {
        return DateUtil.getSimpleDateFormat().format(new Date());
    }

    public static String currentDate(String formatStr) {
        SimpleDateFormat format = null;
        format = formatStr == null || "".trim().equals(formatStr) ? DateUtil.getSimpleDateFormat() : new SimpleDateFormat(formatStr);
        return format.format(new Date());
    }

    public static java.sql.Date currentSqlDate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static java.sql.Date toSqlDate(Date date) {
        return new java.sql.Date(date.getTime());
    }

    public static Timestamp toTimestamp(String dateString) {
        try {
            Date date = DateUtil.getSimpleDateFormat().parse(dateString);
            return new Timestamp(date.getTime());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static Timestamp toTimestamp(Date date) {
        try {
            return new Timestamp(date.getTime());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static String toDateStr(Date date) {
        try {
            return DateUtil.getSimpleDateFormat().format(date);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp jumpDaysExact(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, days);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp jumpDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, days);
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp jumpDays(Timestamp base, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(base);
        cal.add(5, days);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static boolean isNowEffect(Timestamp expirationDate) {
        Calendar now = Calendar.getInstance();
        return now.getTime().before(expirationDate);
    }

    public static int countAge(String birthDateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date birthDate = null;
        int age = 0;
        try {
            birthDate = dateFormat.parse(birthDateString);
        }
        catch (ParseException e) {
            throw ExceptionHelper.convert(e);
        }
        Calendar currentDate = Calendar.getInstance();
        Calendar birthCalendar = Calendar.getInstance();
        birthCalendar.setTime(birthDate);
        age = currentDate.get(1) - birthCalendar.get(1);
        if (currentDate.get(2) < birthCalendar.get(2) || currentDate.get(2) == birthCalendar.get(2) && currentDate.get(5) < birthCalendar.get(5)) {
            --age;
        }
        return age;
    }

    public static boolean checkDate(String dataStr, String dateFormatStr) {
        if (dataStr == null || StringUtils.isBlank(dateFormatStr)) {
            return false;
        }
        String regex = dateFormatStr.replace("yyyy", yyyy).replace("MM", MM).replace("dd", dd);
        boolean flag = dataStr.matches(regex);
        if (!flag) {
            return flag;
        }
        int m1 = dateFormatStr.indexOf(77);
        String tempMM = dataStr.substring(m1, m1 + 2);
        if ("02".equals(tempMM)) {
            int d1 = dateFormatStr.indexOf(100);
            String tempdd = dataStr.substring(d1, d1 + 2);
            if ("30".equals(tempdd) || "31".equals(tempdd)) {
                return false;
            }
            if (!"29".equals(tempdd)) {
                return true;
            }
        } else if ("04".equals(tempMM) || "06".equals(tempMM) || "09".equals(tempMM) || "11".equals(tempMM)) {
            int d1 = dateFormatStr.indexOf(100);
            String tempdd = dataStr.substring(d1, d1 + 2);
            return !"31".equals(tempdd);
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatStr);
            dateFormat.setLenient(false);
            dateFormat.parse(dataStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean yyyy_MM_dd(String dataStr) {
        return DateUtil._checkDate(dataStr, regex1, "yyyy-MM-dd");
    }

    public static boolean yyyyMMdd(String dataStr) {
        return DateUtil._checkDate(dataStr, regex2, "yyyyMMdd");
    }

    private static boolean _checkDate(String dataStr, String regex, String format) {
        if (dataStr == null || regex == null) {
            return false;
        }
        boolean flag = dataStr.matches(regex);
        if (!flag) {
            return flag;
        }
        if (!dataStr.endsWith("02-29") && !dataStr.endsWith("0229")) {
            return flag;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setLenient(false);
            dateFormat.parse(dataStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

