/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.sharding.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.honey.osql.core.OrderByPagingRewriteSql;
import org.teasoft.honey.osql.core.ShardingLogReg;
import org.teasoft.honey.sharding.ShardingUtil;
import org.teasoft.honey.sharding.engine.ResultMergeEngine;
import org.teasoft.honey.sharding.engine.ShardingAbstractBeeSQLExecutorEngine;
import org.teasoft.honey.sharding.engine.ThreadPoolUtil;
import org.teasoft.honey.sharding.engine.decorate.ResultPagingDecorator;
import org.teasoft.honey.sharding.engine.decorate.SortStringArrayListDecorator;

public class ShardingSelectListStringArrayEngine {
    public List<String[]> asynProcess(String sql, BeeSql beeSql, Class entityClass) {
        String[] sqls = null;
        String[] dsArray = null;
        List<String[]> list = ShardingUtil.hadShardingFullSelect() ? OrderByPagingRewriteSql.createSqlsForFullSelect(sql, entityClass) : OrderByPagingRewriteSql.createSqlsAndInit(sql);
        sqls = list.get(0);
        dsArray = list.get(1);
        if (sqls == null || sqls.length == 0) {
            return null;
        }
        ExecutorService executor = ThreadPoolUtil.getThreadPool(sqls.length);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        ArrayList<ShardingBeeSQLExecutorEngine> tasks = new ArrayList<ShardingBeeSQLExecutorEngine>();
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            tasks.add(new ShardingBeeSQLExecutorEngine(sqls[i], i + 1, beeSql, dsArray[i]));
        }
        if (sqls != null) {
            ShardingLogReg.log(sqls.length);
        }
        int size = tasks.size();
        for (int i = 0; tasks != null && i < size; ++i) {
            completionService.submit((Callable)tasks.get(i));
        }
        List<String[]> rsList = ResultMergeEngine.merge(completionService, size);
        executor.shutdown();
        SortStringArrayListDecorator.sort(rsList);
        ResultPagingDecorator.pagingList(rsList);
        return rsList;
    }

    private class ShardingBeeSQLExecutorEngine
    extends ShardingAbstractBeeSQLExecutorEngine<List<String[]>> {
        public ShardingBeeSQLExecutorEngine(String sql, int index, BeeSql beeSql, String ds) {
            super(sql, index, beeSql, ds);
        }

        @Override
        public List<String[]> shardingWork() {
            ShardingLogReg.regShardingSqlLog("select SQL", this.index, this.sql);
            return this.beeSql.select(this.sql);
        }
    }
}

