/*
 * Copyright 2016-2021 the original author.All rights reserved.
 * Kingstar(honeysoft@126.com)
 * The license,see the LICENSE file.
 */

package org.teasoft.honey.osql.autogen;

import org.teasoft.bee.osql.api.SuidRich;
import org.teasoft.honey.osql.core.BeeFactoryHelper;

/**
 * 根据Javabean创建表.Create table according to Javabean
 * @author Kingstar
 * @since  1.9
 * @since  2.0
 */
public class Ddl {

	//多种数据库时,static变量,不能改变.
//	private static PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();
//	private static SuidRich suidRich = BeeFactoryHelper.getSuidRich();

	private Ddl() {}
	
	/**
	 * 根据Javabean生成数据库表,Javabean无需配置过多的字段信息.此方法只考虑通用情况,若有详细需求,不建议采用
	 * <br>According to the database table generated by JavaBean, JavaBean does not need to configure 
	 * <br>too much field information. This method only considers the general situation, and is not 
	 * <br>recommended if there are detailed requirements.
	 * @param entityClass class of Javabean
	 * @return flag whether create successfully.if exist and already has data, also return true.
	 * @since 2.0
	 */
	public static <T> boolean createTable(Class<T> entityClass) {
		return createTable(entityClass, false);
	}
	
	/**
	 * 根据Javabean生成数据库表,Javabean无需配置过多的字段信息.此方法只考虑通用情况,若有详细需求,不建议采用
	 * <br>According to the database table generated by JavaBean, JavaBean does not need to configure 
	 * <br>too much field information. This method only considers the general situation, and is not 
	 * <br>recommended if there are detailed requirements.
	 * @param entityClass class of Javabean
	 * @param isDropExistTable whether drop the table before create.
	 * @return flag whether create successfully.
	 * @since 2.0
	 */
	public static <T> boolean createTable(Class<T> entityClass, boolean isDropExistTable) {
		SuidRich suidRich = BeeFactoryHelper.getSuidRich();
		return suidRich.createTable(entityClass, isDropExistTable);
		
	}
	
	public static void setDynamicParameter(String para, String value) {
		BeeFactoryHelper.getSuidRich().setDynamicParameter(para, value);
	}

	/**
	 * 创建通用索引.create normal index
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 */
	public static <T> void indexNormal(Class<T> entityClass, String fields) {
		indexNormal(entityClass, fields, null);
	}

	/**
	 * 创建通用索引.create normal index
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 * @param indexName  index name
	 */
	public static <T> void indexNormal(Class<T> entityClass, String fields, String indexName) {
		SuidRich suidRich = BeeFactoryHelper.getSuidRich();
		suidRich.indexNormal(entityClass, fields, indexName);
	}

	/**
	 * 创建唯一索引.create unique index
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 */
	public static <T> void unique(Class<T> entityClass, String fields) {
		unique(entityClass, fields, null);
	}

	/**
	 * 创建唯一索引.create unique index
	 * @param entityClass table's entityClass(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 * @param indexName  index name
	 */
	public static <T> void unique(Class<T> entityClass, String fields, String indexName) {
		SuidRich suidRich = BeeFactoryHelper.getSuidRich();
		suidRich.unique(entityClass, fields,indexName);
	}

	public static <T> void primaryKey(Class<T> entityClass, String fields) {
		primaryKey(entityClass, fields, null);
	}

	/**
	 * 创建主键,一般是多字段联合主键.create primary key
	 * @param entity table's entity(do not allow null).
	 * @param fields  field name,if more than one,separate with comma.
	 * @param keyName  key name
	 */
	public static <T> void primaryKey(Class<T> entityClass, String fields, String keyName) {
        
		SuidRich suidRich = BeeFactoryHelper.getSuidRich();
		suidRich.primaryKey(entityClass, fields, keyName);
	}
	
	public static <T> void dropIndex(Class<T> entityClass,  String indexName) {
		SuidRich suidRich = BeeFactoryHelper.getSuidRich();
		suidRich.dropIndex(entityClass, indexName);
	}
}
