/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.BatonExecutionSummary;
import org.technologybrewery.baton.Migration;
import org.technologybrewery.baton.MigrationSummary;
import org.technologybrewery.baton.config.FileSet;
import org.technologybrewery.baton.config.MigrationTarget;
import org.technologybrewery.commons.json.AbstractValidatedElement;
import org.technologybrewery.commons.json.ValidatedElement;

@Mojo(name="baton-migrate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BatonMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="baton.baseDirectory", required=true, defaultValue="${project.basedir}")
    protected File baseDirectory;
    @Parameter(property="baton.sourceDirectory", required=true, defaultValue="${project.basedir}/src")
    protected File sourceDirectory;
    @Parameter(property="baton.testDirectory", required=false)
    protected File testDirectory;
    @Parameter
    protected org.apache.maven.shared.model.fileset.FileSet[] fileSets;
    @Parameter(property="baton.migrationsConfigurationFile", required=false, defaultValue="migrations.json")
    protected String migrationsFileName;
    @Parameter(property="baton.deactivateMigrations", required=false)
    protected Set<String> deactivateMigrations;
    @Parameter(property="baton.backupOriginalMigratedFiles", required=false, defaultValue="true")
    protected boolean backupOriginalMigratedFiles;
    @Parameter(property="baton.backupCustomLocation", required=false)
    protected String backupCustomLocation;
    @Parameter(property="baton.numberOfBackupsToKeep", required=true, defaultValue="10")
    protected int numberOfBackupsToKeep;
    private final ObjectMapper objectMapper = this.initializeObjectMapper();
    private Map<String, MigrationTarget> migrations = new HashMap<String, MigrationTarget>();

    protected ObjectMapper initializeObjectMapper() {
        ObjectMapper localObjectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addAbstractTypeMapping(ValidatedElement.class, MigrationTarget.class);
        localObjectMapper.registerModule((Module)module);
        return localObjectMapper;
    }

    protected void defaultFileSets() {
        if (this.fileSets == null) {
            this.getLog().debug((CharSequence)"Defining default file set...");
            ArrayList<org.apache.maven.shared.model.fileset.FileSet> defaultFileSets = new ArrayList<org.apache.maven.shared.model.fileset.FileSet>();
            org.apache.maven.shared.model.fileset.FileSet sourceFileSet = new org.apache.maven.shared.model.fileset.FileSet();
            sourceFileSet.setDirectory(this.sourceDirectory.getAbsolutePath());
            defaultFileSets.add(sourceFileSet);
            this.getLog().debug((CharSequence)String.format("\tAdded: %s", sourceFileSet.getDirectory()));
            if (this.testDirectory != null) {
                org.apache.maven.shared.model.fileset.FileSet testFileSet = new org.apache.maven.shared.model.fileset.FileSet();
                testFileSet.setDirectory(this.testDirectory.getAbsolutePath());
                defaultFileSets.add(testFileSet);
                this.getLog().debug((CharSequence)String.format("\tAdded: %s", testFileSet.getDirectory()));
            }
            org.apache.maven.shared.model.fileset.FileSet rootFileSets = new org.apache.maven.shared.model.fileset.FileSet();
            rootFileSets.setDirectory(this.baseDirectory.getAbsolutePath());
            rootFileSets.addInclude("pom.xml");
            rootFileSets.addInclude("*.toml");
            defaultFileSets.add(rootFileSets);
            this.getLog().debug((CharSequence)String.format("\tAdded: %s with includes: %s", rootFileSets.getDirectory(), rootFileSets.getIncludes()));
            this.fileSets = defaultFileSets.toArray(new org.apache.maven.shared.model.fileset.FileSet[0]);
            this.getLog().debug((CharSequence)"Default file set definition completed");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadMigrations();
        this.defaultFileSets();
        BatonExecutionSummary summary = this.performMigration(this.migrations.values());
        this.getLog().info((CharSequence)summary.getSummary());
    }

    BatonExecutionSummary performMigration(Collection<MigrationTarget> targets) {
        BatonExecutionSummary executionSummary = new BatonExecutionSummary();
        for (MigrationTarget target : targets) {
            if (!this.isActive(target)) continue;
            try {
                this.getLog().debug((CharSequence)String.format("Executing Migration: %s (%s)", target.getName(), target.getImplementation()));
                Class<?> implementationClass = Class.forName(target.getImplementation());
                Constructor<?> constructor = implementationClass.getConstructor(new Class[0]);
                Migration migration = (Migration)constructor.newInstance(new Object[0]);
                migration.setName(target.getName());
                migration.setDescription(target.getDescription());
                migration.setMavenProject(this.project);
                migration.setBackupMigratedOriginalFiles(this.backupOriginalMigratedFiles);
                migration.setBackupCustomLocation(this.backupCustomLocation);
                migration.setNumberOfBacksUpsToKeep(this.numberOfBackupsToKeep);
                org.apache.maven.shared.model.fileset.FileSet[] migrationSpecificFileSets = CollectionUtils.isNotEmpty(target.getFileSets()) ? this.getFileSetsForTarget(target) : this.fileSets;
                MigrationSummary migrationSummary = migration.execute(migrationSpecificFileSets);
                executionSummary.addMigrationSummary(migrationSummary);
            }
            catch (Exception e) {
                throw new BatonException("Could not complete migrations!", e);
            }
        }
        return executionSummary;
    }

    protected boolean isActive(MigrationTarget migrationTarget) {
        String name;
        boolean isActive = true;
        if (CollectionUtils.isNotEmpty(this.deactivateMigrations) && this.deactivateMigrations.contains(name = migrationTarget.getName())) {
            isActive = false;
            this.getLog().info((CharSequence)String.format("Skipping deactivated migration: %s", name));
        }
        return isActive;
    }

    protected void loadMigrations() {
        Enumeration<URL> migrationsEnumeration = null;
        try {
            migrationsEnumeration = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.migrationsFileName);
        }
        catch (IOException ioe) {
            throw new BatonException("Unable to find migrations!", ioe);
        }
        while (migrationsEnumeration.hasMoreElements()) {
            URL migrationsResource = migrationsEnumeration.nextElement();
            this.getLog().info((CharSequence)String.format("Loading migrations from: %s", migrationsResource.toString()));
            try {
                InputStream migrationsStream = migrationsResource.openStream();
                try {
                    File tempMigrationsFile = File.createTempFile("migrations", ".json");
                    Files.copy(migrationsStream, tempMigrationsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.migrations = this.loadMigrationsJson(tempMigrationsFile, this.migrations);
                    this.getLog().info((CharSequence)String.format("Found %d migrations", this.migrations.size()));
                }
                finally {
                    if (migrationsStream == null) continue;
                    migrationsStream.close();
                }
            }
            catch (IOException e) {
                throw new BatonException("Unable to parse " + this.migrationsFileName, e);
            }
        }
    }

    protected Map<String, MigrationTarget> loadMigrationsJson(File migrationsFile, Map<String, MigrationTarget> migrationTargets) {
        List loadedMigrations = AbstractValidatedElement.readAndValidateJsonList((File)migrationsFile, (ObjectMapper)this.objectMapper, MigrationTarget.class);
        for (MigrationTarget migrationTarget : loadedMigrations) {
            migrationTargets.put(migrationTarget.getName(), migrationTarget);
        }
        return migrationTargets;
    }

    protected org.apache.maven.shared.model.fileset.FileSet[] getFileSetsForTarget(MigrationTarget target) {
        ArrayList<org.apache.maven.shared.model.fileset.FileSet> localFileSets = new ArrayList<org.apache.maven.shared.model.fileset.FileSet>();
        for (FileSet targetFileSet : target.getFileSets()) {
            org.apache.maven.shared.model.fileset.FileSet fileSet = new org.apache.maven.shared.model.fileset.FileSet();
            fileSet.setDirectory(targetFileSet.getDirectory());
            if (fileSet.getDirectory() == null) {
                fileSet.setDirectory(this.baseDirectory.getAbsolutePath());
            }
            if (CollectionUtils.isNotEmpty(targetFileSet.getIncludes())) {
                for (String include : targetFileSet.getIncludes()) {
                    fileSet.addInclude(include);
                }
            }
            if (CollectionUtils.isNotEmpty(targetFileSet.getExcludes())) {
                for (String exclude : targetFileSet.getExcludes()) {
                    fileSet.addExclude(exclude);
                }
            }
            if (targetFileSet.getFollowSymlinks() != null) {
                fileSet.setFollowSymlinks(targetFileSet.getFollowSymlinks().booleanValue());
            }
            localFileSets.add(fileSet);
        }
        return localFileSets.isEmpty() ? this.fileSets : localFileSets.toArray(new org.apache.maven.shared.model.fileset.FileSet[0]);
    }
}

