/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.StringUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static boolean replaceLiteralInFile(File file, String toReplace, String replacement) throws IOException {
        boolean replacedInFile = false;
        if (file != null && file.exists()) {
            String content = new String(Files.readAllBytes(file.toPath()));
            content = content.replace(toReplace, replacement);
            Files.write(file.toPath(), content.getBytes(), new OpenOption[0]);
            replacedInFile = true;
        }
        return replacedInFile;
    }

    public static boolean replaceInFile(File file, String regex, String replacement) throws IOException {
        boolean replacedInFile = false;
        if (file != null && file.exists()) {
            Charset charset = StandardCharsets.UTF_8;
            String fileContent = new String(Files.readAllBytes(file.toPath()), charset);
            Pattern pattern = Pattern.compile(regex, 8);
            Matcher matcher = pattern.matcher(fileContent);
            String newFileContent = matcher.replaceAll(replacement);
            IOUtils.write((String)newFileContent, (OutputStream)new FileOutputStream(file), (Charset)charset);
            replacedInFile = true;
        }
        return replacedInFile;
    }

    public static boolean modifyRegexMatchInFile(File file, String regex, String substring, String replacement) {
        if (file == null || !file.exists()) {
            return false;
        }
        boolean modified = false;
        try {
            Path path = file.toPath();
            Charset charset = StandardCharsets.UTF_8;
            ArrayList<String> resultLines = new ArrayList<String>();
            Pattern pattern = Pattern.compile(regex);
            for (String line : Files.readAllLines(path, charset)) {
                if (pattern.matcher(line).find()) {
                    line = line.replace(substring, replacement);
                    modified = true;
                }
                resultLines.add(line);
            }
            if (modified) {
                Files.write(path, resultLines, charset, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            return false;
        }
        return modified;
    }

    public static List<String> readAllFileLines(File file) throws IOException {
        return Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
    }

    public static void writeFile(File file, List<String> contents) throws IOException {
        Files.write(file.toPath(), contents, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static List<String> getRegExCaptureGroups(String regex, File file) throws IOException {
        String fileContent = "";
        if (file != null && file.exists()) {
            Charset charset = StandardCharsets.UTF_8;
            fileContent = new String(Files.readAllBytes(file.toPath()), charset);
        }
        return StringUtils.isNotEmpty((String)fileContent) ? FileUtils.getRegExCaptureGroups(regex, fileContent) : new ArrayList();
    }

    public static List<String> getRegExCaptureGroups(String regex, String input) {
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> captured = new ArrayList<String>();
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                captured.add(matcher.group(i));
            }
        }
        return captured;
    }

    public static boolean hasRegExMatch(String regex, File file) throws IOException {
        if (file != null && file.exists()) {
            Charset charset = StandardCharsets.UTF_8;
            String fileContent = Files.readString(file.toPath(), charset);
            return Pattern.compile(regex, 8).matcher(fileContent).find();
        }
        return false;
    }

    public static String getIndent(String line, int level) {
        int i;
        if (level < 1) {
            return "";
        }
        for (i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
        }
        return line.substring(0, i / level);
    }

    public static void indentValues(List<String> values, int numSpaces) {
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i).isBlank()) continue;
            values.set(i, " ".repeat(numSpaces) + values.get(i));
        }
    }
}

