/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.GroupSummary;
import org.technologybrewery.baton.MigrationSummary;

public class BatonExecutionSummary {
    private static final Logger logger = LoggerFactory.getLogger(BatonExecutionSummary.class);
    private List<GroupSummary> groupSummaries = new ArrayList<GroupSummary>();

    public void addGroupSummary(GroupSummary summary) {
        if (summary == null) {
            logger.warn("Mission migration summary details - file counts may be inaccurate!");
        } else {
            this.groupSummaries.add(summary);
        }
    }

    public int getNumberOfTargetsExecuted() {
        int numberOfTargetsExecuted = 0;
        for (GroupSummary groupSummary : this.groupSummaries) {
            numberOfTargetsExecuted += groupSummary.getMigrationSummaries().size();
        }
        return numberOfTargetsExecuted;
    }

    public List<GroupSummary> getGroupSummaries() {
        return this.groupSummaries;
    }

    public String getSummary() {
        int filesSuccess = 0;
        int filesUnsuccess = 0;
        for (GroupSummary groupSummary : this.groupSummaries) {
            for (MigrationSummary migrationSummary : groupSummary.getMigrationSummaries()) {
                filesSuccess += migrationSummary.getFilesSuccessfullyMigrated();
                filesUnsuccess += migrationSummary.getFilesUnsuccessfullyMigrated();
            }
        }
        return String.format("Migrations Processed: %d, Successfully Migrated Files: %d, Unsuccessfully Migrated Files: %d", this.getNumberOfTargetsExecuted(), filesSuccess, filesUnsuccess);
    }
}

