/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton.util.pom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.util.pom.LocationAwareMavenReader;
import org.technologybrewery.baton.util.pom.PomModifications;

public final class PomHelper {
    private PomHelper() {
    }

    public static Model getLocationAnnotatedModel(File file) {
        LocationAwareMavenReader reader = new LocationAwareMavenReader();
        InputSource source = new InputSource();
        source.setLocation(file.getAbsolutePath());
        try {
            return reader.read(new FileReader(file), true, source);
        }
        catch (IOException | XmlPullParserException e) {
            throw new BatonException("Unable to parse pom file at path: " + file.getAbsolutePath(), e);
        }
    }

    public static boolean writeModifications(File file, PomModifications.Final modifications) {
        String tempFile = file.getAbsolutePath() + ".tmp";
        try (FileWriter out = new FileWriter(tempFile);
             BufferedReader in = new BufferedReader(new FileReader(file));){
            String line;
            int lineNumber = 0;
            while ((line = in.readLine()) != null) {
                if (modifications.appliesTo(++lineNumber)) {
                    lineNumber = modifications.apply(in, out, line);
                    continue;
                }
                out.write(line);
                out.write("\n");
            }
            Files.move(Paths.get(tempFile, new String[0]), Paths.get(file.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new BatonException("Failed to update file:" + file.getPath(), e);
        }
        return true;
    }

    public static InputLocation incrementColumn(InputLocation location, int columnIndexShift) {
        return new InputLocation(location.getLineNumber(), location.getColumnNumber() + columnIndexShift, location.getSource());
    }
}

