/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton;

import com.vlkan.rfos.RotatingFileOutputStream;
import com.vlkan.rfos.RotationConfig;
import com.vlkan.rfos.policy.RotationPolicy;
import com.vlkan.rfos.policy.SizeBasedRotationPolicy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.Migration;
import org.technologybrewery.baton.MigrationSummary;

public abstract class AbstractMigration
implements Migration {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMigration.class);
    protected String name;
    protected String description;
    protected boolean active = true;
    protected Set<String> fileNamePatterns;
    protected boolean backupOriginalMigratedFiles;
    protected String backupCustomLocation;
    protected int numberOfBackupsToKeep;
    protected MavenProject project;

    @Override
    public MigrationSummary execute(FileSet[] fileSets) {
        if (!this.active) {
            logger.info("Migration {}' is marked inactive - skipping", (Object)this.getName());
            return new MigrationSummary(this.name, 0, 0);
        }
        FileSetManager fileSetManager = new FileSetManager();
        int successfulMigrations = 0;
        int unsuccessfulMigrations = 0;
        for (FileSet fileSet : fileSets) {
            String[] includedFiles;
            for (String file : includedFiles = fileSetManager.getIncludedFiles(fileSet)) {
                File fileToMigrate = new File(fileSet.getDirectory(), file);
                if (!this.shouldExecuteOnFile(fileToMigrate)) continue;
                this.backupOriginalFile(fileToMigrate);
                try {
                    boolean successful = this.performMigration(fileToMigrate);
                    if (successful) {
                        ++successfulMigrations;
                        continue;
                    }
                    ++unsuccessfulMigrations;
                }
                catch (Exception e) {
                    ++unsuccessfulMigrations;
                    logger.error(String.format("Problem performing migration on %s!", fileToMigrate.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return new MigrationSummary(this.name, successfulMigrations, unsuccessfulMigrations);
    }

    protected abstract boolean shouldExecuteOnFile(File var1);

    protected abstract boolean performMigration(File var1);

    protected void backupOriginalFile(File originalFile) {
        if (this.shouldBackupMigratedOriginalFiles()) {
            try {
                Object persistentBackupPathBase = StringUtils.isNotBlank((CharSequence)this.backupCustomLocation) ? this.getBasedir().getAbsolutePath() + "/" + this.backupCustomLocation : FileUtils.getTempDirectoryPath();
                String originalPathAsString = Paths.get(originalFile.toURI()).toString();
                String baseDirectoryFilePath = Paths.get(this.getBasedir().toURI()).toString();
                String localPath = originalPathAsString.replace(baseDirectoryFilePath, "");
                File backupFile = new File((String)persistentBackupPathBase, "baton/" + this.getMavenProject().getArtifactId() + "/" + localPath + ".orig");
                FileUtils.createParentDirectories((File)backupFile);
                this.createBackupAndRotateAnyPriorVersions(originalFile, backupFile);
                this.createSymlinkInTargetToPersistentBackup(localPath, backupFile);
            }
            catch (IOException e) {
                throw new BatonException("Could not backup original file!", e);
            }
        }
    }

    private void createBackupAndRotateAnyPriorVersions(File originalFile, File backupFile) throws IOException {
        RotationConfig config = RotationConfig.builder().file(backupFile.getAbsoluteFile()).maxBackupCount(this.getNumberOfBacksUpsToKeep()).policy((RotationPolicy)new SizeBasedRotationPolicy(FileUtils.sizeOf((File)originalFile))).build();
        try (RotatingFileOutputStream stream = new RotatingFileOutputStream(config);){
            FileUtils.copyFile((File)originalFile, (OutputStream)stream);
            logger.debug("Original copy backed up to: {}", (Object)backupFile.getAbsoluteFile());
        }
    }

    private void createSymlinkInTargetToPersistentBackup(String localPath, File backupFile) throws IOException {
        File symlinkBackupFile = new File(this.getBuildDir(), "baton" + localPath + ".orig");
        FileUtils.createParentDirectories((File)symlinkBackupFile);
        if (!symlinkBackupFile.exists()) {
            Path symlinkPath = Paths.get(symlinkBackupFile.toURI());
            Path backupFilePath = Paths.get(backupFile.toURI());
            Files.createSymbolicLink(symlinkPath, backupFilePath, new FileAttribute[0]);
        }
    }

    protected File getBasedir() {
        return this.project.getBasedir();
    }

    protected String getBuildDir() {
        return this.project.getBuild().getDirectory();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Set<String> getFileNamePatterns() {
        return this.fileNamePatterns;
    }

    @Override
    public void setFileNamePatterns(Set<String> fileNamePatterns) {
        this.fileNamePatterns = fileNamePatterns;
    }

    @Override
    public boolean shouldBackupMigratedOriginalFiles() {
        return this.backupOriginalMigratedFiles;
    }

    @Override
    public void setBackupMigratedOriginalFiles(boolean backupOriginalMigratedFiles) {
        this.backupOriginalMigratedFiles = backupOriginalMigratedFiles;
    }

    public boolean isBackupOriginalMigratedFiles() {
        return this.backupOriginalMigratedFiles;
    }

    public void setBackupOriginalMigratedFiles(boolean backupOriginalMigratedFiles) {
        this.backupOriginalMigratedFiles = backupOriginalMigratedFiles;
    }

    @Override
    public String getBackupCustomLocation() {
        return this.backupCustomLocation;
    }

    @Override
    public void setBackupCustomLocation(String backupCustomLocation) {
        this.backupCustomLocation = backupCustomLocation;
    }

    @Override
    public int getNumberOfBacksUpsToKeep() {
        return this.numberOfBackupsToKeep;
    }

    @Override
    public void setNumberOfBacksUpsToKeep(int numberOfBacksUpsToKeep) {
        this.numberOfBackupsToKeep = numberOfBacksUpsToKeep;
    }

    @Override
    public void setMavenProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.project;
    }
}

