/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.BatonExecutionSummary;
import org.technologybrewery.baton.GroupSummary;
import org.technologybrewery.baton.Migration;
import org.technologybrewery.baton.MigrationSummary;
import org.technologybrewery.baton.config.FileSet;
import org.technologybrewery.baton.config.GroupTarget;
import org.technologybrewery.baton.config.MigrationTarget;
import org.technologybrewery.commons.json.AbstractValidatedElement;
import org.technologybrewery.commons.json.ValidatedElement;

@Mojo(name="baton-migrate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BatonMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="baton.baseDirectory", required=true, defaultValue="${project.basedir}")
    protected File baseDirectory;
    @Parameter(property="baton.sourceDirectory", required=true, defaultValue="${project.basedir}/src")
    protected File sourceDirectory;
    @Parameter(property="baton.testDirectory", required=false)
    protected File testDirectory;
    @Parameter(property="baton.minimumVersion", required=false, defaultValue="0.0.0")
    protected String minimumVersion;
    @Parameter
    protected org.apache.maven.shared.model.fileset.FileSet[] fileSets;
    @Parameter(property="baton.migrationsConfigurationFile", required=false, defaultValue="migrations.json")
    protected String migrationsFileName;
    @Parameter(property="baton.deactivateMigrations", required=false)
    protected Set<String> deactivateMigrations;
    @Parameter(property="baton.backupOriginalMigratedFiles", required=false, defaultValue="true")
    protected boolean backupOriginalMigratedFiles;
    @Parameter(property="baton.backupCustomLocation", required=false)
    protected String backupCustomLocation;
    @Parameter(property="baton.numberOfBackupsToKeep", required=true, defaultValue="10")
    protected int numberOfBackupsToKeep;
    private final ObjectMapper objectMapper = this.initializeObjectMapper();
    private List<GroupTarget> groups = new ArrayList<GroupTarget>();
    protected static final String VERSIONED = "versioned";
    protected static final String ORDERED = "ordered";
    private static final String minVersionPattern = "\\d+\\.\\d+\\.\\d+";

    protected ObjectMapper initializeObjectMapper() {
        ObjectMapper localObjectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addAbstractTypeMapping(ValidatedElement.class, GroupTarget.class);
        localObjectMapper.registerModule((Module)module);
        return localObjectMapper;
    }

    protected void defaultFileSets() {
        if (this.fileSets == null) {
            this.getLog().debug((CharSequence)"Defining default file set...");
            ArrayList<org.apache.maven.shared.model.fileset.FileSet> defaultFileSets = new ArrayList<org.apache.maven.shared.model.fileset.FileSet>();
            org.apache.maven.shared.model.fileset.FileSet sourceFileSet = new org.apache.maven.shared.model.fileset.FileSet();
            sourceFileSet.setDirectory(this.sourceDirectory.getAbsolutePath());
            defaultFileSets.add(sourceFileSet);
            this.getLog().debug((CharSequence)String.format("\tAdded: %s", sourceFileSet.getDirectory()));
            if (this.testDirectory != null) {
                org.apache.maven.shared.model.fileset.FileSet testFileSet = new org.apache.maven.shared.model.fileset.FileSet();
                testFileSet.setDirectory(this.testDirectory.getAbsolutePath());
                defaultFileSets.add(testFileSet);
                this.getLog().debug((CharSequence)String.format("\tAdded: %s", testFileSet.getDirectory()));
            }
            org.apache.maven.shared.model.fileset.FileSet rootFileSets = new org.apache.maven.shared.model.fileset.FileSet();
            rootFileSets.setDirectory(this.baseDirectory.getAbsolutePath());
            rootFileSets.addInclude("pom.xml");
            rootFileSets.addInclude("*.toml");
            defaultFileSets.add(rootFileSets);
            this.getLog().debug((CharSequence)String.format("\tAdded: %s with includes: %s", rootFileSets.getDirectory(), rootFileSets.getIncludes()));
            this.fileSets = defaultFileSets.toArray(new org.apache.maven.shared.model.fileset.FileSet[0]);
            this.getLog().debug((CharSequence)"Default file set definition completed");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateMinimumVersion();
        this.loadMigrations();
        this.sortMigrationsInGroups(this.groups);
        this.defaultFileSets();
        BatonExecutionSummary summary = this.performMigration(this.groups);
        this.getLog().info((CharSequence)summary.getSummary());
    }

    private void validateMinimumVersion() {
        Pattern pattern = Pattern.compile(minVersionPattern);
        Matcher matcher = pattern.matcher(this.minimumVersion);
        if (!matcher.find()) {
            this.minimumVersion = "0.0.0";
            this.getLog().warn((CharSequence)String.format("Invalid format for minimum version %s, setting to 0.0.0. Must be of the format [Number].[Number].[Number]", this.minimumVersion));
        }
    }

    protected void sortMigrationsInGroups(List<GroupTarget> groupTargets) {
        for (GroupTarget groupTarget : groupTargets) {
            if (!groupTarget.getType().equals(VERSIONED)) continue;
            Collections.sort(groupTarget.getMigrations(), new Comparator<MigrationTarget>(){

                @Override
                public int compare(MigrationTarget o1, MigrationTarget o2) {
                    return o1.getVersion().compareTo(o2.getVersion());
                }
            });
        }
    }

    BatonExecutionSummary performMigration(Collection<GroupTarget> groupTargets) {
        BatonExecutionSummary executionSummary = new BatonExecutionSummary();
        for (GroupTarget groupTarget : groupTargets) {
            GroupSummary groupSummary = new GroupSummary(groupTarget.getGroup());
            for (MigrationTarget migrationTarget : groupTarget.getMigrations()) {
                if (!this.isActive(migrationTarget) || !this.isMinimumVersion(migrationTarget, groupTarget.getType())) continue;
                try {
                    this.getLog().debug((CharSequence)String.format("Executing Migration: %s (%s)", migrationTarget.getName(), migrationTarget.getImplementation()));
                    Class<?> implementationClass = Class.forName(migrationTarget.getImplementation());
                    Constructor<?> constructor = implementationClass.getConstructor(new Class[0]);
                    Migration migration = (Migration)constructor.newInstance(new Object[0]);
                    migration.setName(migrationTarget.getName());
                    migration.setDescription(migrationTarget.getDescription());
                    migration.setMavenProject(this.project);
                    migration.setBackupMigratedOriginalFiles(this.backupOriginalMigratedFiles);
                    migration.setBackupCustomLocation(this.backupCustomLocation);
                    migration.setNumberOfBacksUpsToKeep(this.numberOfBackupsToKeep);
                    org.apache.maven.shared.model.fileset.FileSet[] migrationSpecificFileSets = CollectionUtils.isNotEmpty(migrationTarget.getFileSets()) ? this.getFileSetsForTarget(migrationTarget) : this.fileSets;
                    MigrationSummary migrationSummary = migration.execute(migrationSpecificFileSets);
                    groupSummary.addMigrationSummary(migrationSummary);
                }
                catch (Exception e) {
                    throw new BatonException("Could not complete migrations!", e);
                }
            }
            executionSummary.addGroupSummary(groupSummary);
        }
        return executionSummary;
    }

    protected boolean isActive(MigrationTarget migrationTarget) {
        String name;
        boolean isActive = true;
        if (CollectionUtils.isNotEmpty(this.deactivateMigrations) && this.deactivateMigrations.contains(name = migrationTarget.getName())) {
            isActive = false;
            this.getLog().info((CharSequence)String.format("Skipping deactivated migration: %s", name));
        }
        return isActive;
    }

    protected boolean isMinimumVersion(MigrationTarget migrationTarget, String groupType) {
        boolean isMinimumVersion = true;
        if (groupType.equals(VERSIONED)) {
            boolean bl = isMinimumVersion = migrationTarget.getVersion().compareTo(this.minimumVersion) >= 0;
        }
        if (!isMinimumVersion) {
            this.getLog().info((CharSequence)String.format("Skipping, migration %s with version %s does not meet minimum version of %s", migrationTarget.getName(), migrationTarget.getVersion(), this.minimumVersion));
        }
        return isMinimumVersion;
    }

    protected void loadMigrations() {
        Enumeration<URL> groupsEnumeration = null;
        try {
            groupsEnumeration = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.migrationsFileName);
        }
        catch (IOException ioe) {
            throw new BatonException("Unable to find migrations!", ioe);
        }
        while (groupsEnumeration.hasMoreElements()) {
            URL groupsResource = groupsEnumeration.nextElement();
            this.getLog().info((CharSequence)String.format("Loading migrations from: %s", groupsResource.toString()));
            try {
                InputStream migrationsStream = groupsResource.openStream();
                try {
                    File tempMigrationsFile = File.createTempFile("migrations", ".json");
                    Files.copy(migrationsStream, tempMigrationsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    List groupTargets = AbstractValidatedElement.readAndValidateJsonList((File)tempMigrationsFile, (ObjectMapper)this.objectMapper, GroupTarget.class);
                    this.groups.addAll(groupTargets);
                    this.getLog().info((CharSequence)String.format("Found %d migrations", this.groups.size()));
                }
                finally {
                    if (migrationsStream == null) continue;
                    migrationsStream.close();
                }
            }
            catch (IOException e) {
                throw new BatonException("Unable to parse " + this.migrationsFileName, e);
            }
        }
    }

    protected org.apache.maven.shared.model.fileset.FileSet[] getFileSetsForTarget(MigrationTarget target) {
        ArrayList<org.apache.maven.shared.model.fileset.FileSet> localFileSets = new ArrayList<org.apache.maven.shared.model.fileset.FileSet>();
        for (FileSet targetFileSet : target.getFileSets()) {
            org.apache.maven.shared.model.fileset.FileSet fileSet = new org.apache.maven.shared.model.fileset.FileSet();
            fileSet.setDirectory(targetFileSet.getDirectory());
            if (fileSet.getDirectory() == null) {
                fileSet.setDirectory(this.baseDirectory.getAbsolutePath());
            }
            if (CollectionUtils.isNotEmpty(targetFileSet.getIncludes())) {
                for (String include : targetFileSet.getIncludes()) {
                    fileSet.addInclude(include);
                }
            }
            if (CollectionUtils.isNotEmpty(targetFileSet.getExcludes())) {
                for (String exclude : targetFileSet.getExcludes()) {
                    fileSet.addExclude(exclude);
                }
            }
            if (targetFileSet.getFollowSymlinks() != null) {
                fileSet.setFollowSymlinks(targetFileSet.getFollowSymlinks().booleanValue());
            }
            localFileSets.add(fileSet);
        }
        return localFileSets.isEmpty() ? this.fileSets : localFileSets.toArray(new org.apache.maven.shared.model.fileset.FileSet[0]);
    }
}

