/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.baton.util.pom;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class LocationAwareMavenReader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;
    public static final String START = new Object().toString();
    public static final String END = new Object().toString();

    public LocationAwareMavenReader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public LocationAwareMavenReader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Model read(Reader reader, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict, source);
    }

    public Model read(InputStream in, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict, source);
    }

    private Activation parseActivation(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Activation activation = new Activation();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        activation.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "activeByDefault", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activation.setLocation((Object)"activeByDefault", _location);
                activation.setActiveByDefault(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "activeByDefault"), "activeByDefault", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "jdk", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activation.setLocation((Object)"jdk", _location);
                activation.setJdk(this.interpolatedTrimmed(parser.nextText(), "jdk"));
                this.setWrapLocation((InputLocationTracker)activation, parser, "jdk");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "os", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activation.setLocation((Object)"os", _location);
                activation.setOs(this.parseActivationOS(parser, strict, source));
                this.setWrapLocation((InputLocationTracker)activation, parser, "os");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "property", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activation.setLocation((Object)"property", _location);
                activation.setProperty(this.parseActivationProperty(parser, strict, source));
                this.setWrapLocation((InputLocationTracker)activation, parser, "property");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "file", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activation.setLocation((Object)"file", _location);
                activation.setFile(this.parseActivationFile(parser, strict, source));
                this.setWrapLocation((InputLocationTracker)activation, parser, "file");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)activation, parser);
        return activation;
    }

    private ActivationFile parseActivationFile(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationFile activationFile = new ActivationFile();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        activationFile.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "missing", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationFile.setLocation((Object)"missing", _location);
                activationFile.setMissing(this.interpolatedTrimmed(parser.nextText(), "missing"));
                this.setWrapLocation((InputLocationTracker)activationFile, parser, "missing");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "exists", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationFile.setLocation((Object)"exists", _location);
                activationFile.setExists(this.interpolatedTrimmed(parser.nextText(), "exists"));
                this.setWrapLocation((InputLocationTracker)activationFile, parser, "exists");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)activationFile, parser);
        return activationFile;
    }

    private ActivationOS parseActivationOS(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationOS activationOS = new ActivationOS();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        activationOS.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationOS.setLocation((Object)"name", _location);
                activationOS.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)activationOS, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "family", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationOS.setLocation((Object)"family", _location);
                activationOS.setFamily(this.interpolatedTrimmed(parser.nextText(), "family"));
                this.setWrapLocation((InputLocationTracker)activationOS, parser, "family");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "arch", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationOS.setLocation((Object)"arch", _location);
                activationOS.setArch(this.interpolatedTrimmed(parser.nextText(), "arch"));
                this.setWrapLocation((InputLocationTracker)activationOS, parser, "arch");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationOS.setLocation((Object)"version", _location);
                activationOS.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)activationOS, parser, "version");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)activationOS, parser);
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationProperty activationProperty = new ActivationProperty();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        activationProperty.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationProperty.setLocation((Object)"name", _location);
                activationProperty.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)activationProperty, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "value", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                activationProperty.setLocation((Object)"value", _location);
                activationProperty.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
                this.setWrapLocation((InputLocationTracker)activationProperty, parser, "value");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)activationProperty, parser);
        return activationProperty;
    }

    private Build parseBuild(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Build build = new Build();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        build.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "sourceDirectory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"sourceDirectory", _location);
                build.setSourceDirectory(this.interpolatedTrimmed(parser.nextText(), "sourceDirectory"));
                this.setWrapLocation((InputLocationTracker)build, parser, "sourceDirectory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scriptSourceDirectory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"scriptSourceDirectory", _location);
                build.setScriptSourceDirectory(this.interpolatedTrimmed(parser.nextText(), "scriptSourceDirectory"));
                this.setWrapLocation((InputLocationTracker)build, parser, "scriptSourceDirectory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testSourceDirectory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"testSourceDirectory", _location);
                build.setTestSourceDirectory(this.interpolatedTrimmed(parser.nextText(), "testSourceDirectory"));
                this.setWrapLocation((InputLocationTracker)build, parser, "testSourceDirectory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"outputDirectory", _location);
                build.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                this.setWrapLocation((InputLocationTracker)build, parser, "outputDirectory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testOutputDirectory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"testOutputDirectory", _location);
                build.setTestOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "testOutputDirectory"));
                this.setWrapLocation((InputLocationTracker)build, parser, "testOutputDirectory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "extensions", null, parsed)) {
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                build.setExtensions(extensions);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"extensions", _locations);
                while (parser.nextTag() == 2) {
                    if ("extension".equals(parser.getName())) {
                        extensions.add(this.parseExtension(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)build, parser, "extensions");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "defaultGoal", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"defaultGoal", _location);
                build.setDefaultGoal(this.interpolatedTrimmed(parser.nextText(), "defaultGoal"));
                this.setWrapLocation((InputLocationTracker)build, parser, "defaultGoal");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                build.setResources(resources);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"resources", _locations);
                while (parser.nextTag() == 2) {
                    if ("resource".equals(parser.getName())) {
                        resources.add(this.parseResource(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)build, parser, "resources");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                build.setTestResources(testResources);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"testResources", _locations);
                while (parser.nextTag() == 2) {
                    if ("testResource".equals(parser.getName())) {
                        testResources.add(this.parseResource(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)build, parser, "testResources");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"directory", _location);
                build.setDirectory(this.interpolatedTrimmed(parser.nextText(), "directory"));
                this.setWrapLocation((InputLocationTracker)build, parser, "directory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "finalName", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"finalName", _location);
                build.setFinalName(this.interpolatedTrimmed(parser.nextText(), "finalName"));
                this.setWrapLocation((InputLocationTracker)build, parser, "finalName");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                build.setFilters(filters);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"filters", _locations);
                while (parser.nextTag() == 2) {
                    if ("filter".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)filters.size(), _location);
                        filters.add(this.interpolatedTrimmed(parser.nextText(), "filters"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, filters.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)build, parser, "filters");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginManagement", null, parsed)) {
                build.setPluginManagement(this.parsePluginManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                build.setPlugins(plugins);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                build.setLocation((Object)"plugins", _locations);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePlugin(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)build, parser, "plugins");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)build, parser);
        return build;
    }

    private BuildBase parseBuildBase(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        BuildBase buildBase = new BuildBase();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        buildBase.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "defaultGoal", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                buildBase.setLocation((Object)"defaultGoal", _location);
                buildBase.setDefaultGoal(this.interpolatedTrimmed(parser.nextText(), "defaultGoal"));
                this.setWrapLocation((InputLocationTracker)buildBase, parser, "defaultGoal");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                buildBase.setResources(resources);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                buildBase.setLocation((Object)"resources", _locations);
                while (parser.nextTag() == 2) {
                    if ("resource".equals(parser.getName())) {
                        resources.add(this.parseResource(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)buildBase, parser, "resources");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                buildBase.setTestResources(testResources);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                buildBase.setLocation((Object)"testResources", _locations);
                while (parser.nextTag() == 2) {
                    if ("testResource".equals(parser.getName())) {
                        testResources.add(this.parseResource(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)buildBase, parser, "testResources");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                buildBase.setLocation((Object)"directory", _location);
                buildBase.setDirectory(this.interpolatedTrimmed(parser.nextText(), "directory"));
                this.setWrapLocation((InputLocationTracker)buildBase, parser, "directory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "finalName", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                buildBase.setLocation((Object)"finalName", _location);
                buildBase.setFinalName(this.interpolatedTrimmed(parser.nextText(), "finalName"));
                this.setWrapLocation((InputLocationTracker)buildBase, parser, "finalName");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                buildBase.setFilters(filters);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                buildBase.setLocation((Object)"filters", _locations);
                while (parser.nextTag() == 2) {
                    if ("filter".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)filters.size(), _location);
                        filters.add(this.interpolatedTrimmed(parser.nextText(), "filters"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, filters.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)buildBase, parser, "filters");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginManagement", null, parsed)) {
                buildBase.setPluginManagement(this.parsePluginManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                buildBase.setPlugins(plugins);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                buildBase.setLocation((Object)"plugins", _locations);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePlugin(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)buildBase, parser, "plugins");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)buildBase, parser);
        return buildBase;
    }

    private CiManagement parseCiManagement(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CiManagement ciManagement = new CiManagement();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        ciManagement.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "system", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                ciManagement.setLocation((Object)"system", _location);
                ciManagement.setSystem(this.interpolatedTrimmed(parser.nextText(), "system"));
                this.setWrapLocation((InputLocationTracker)ciManagement, parser, "system");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                ciManagement.setLocation((Object)"url", _location);
                ciManagement.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)ciManagement, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "notifiers", null, parsed)) {
                ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                ciManagement.setNotifiers(notifiers);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                ciManagement.setLocation((Object)"notifiers", _locations);
                while (parser.nextTag() == 2) {
                    if ("notifier".equals(parser.getName())) {
                        notifiers.add(this.parseNotifier(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)ciManagement, parser, "notifiers");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)ciManagement, parser);
        return ciManagement;
    }

    private ConfigurationContainer parseConfigurationContainer(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ConfigurationContainer configurationContainer = new ConfigurationContainer();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        configurationContainer.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                configurationContainer.setLocation((Object)"inherited", _location);
                configurationContainer.setInherited(this.interpolatedTrimmed(parser.nextText(), "inherited"));
                this.setWrapLocation((InputLocationTracker)configurationContainer, parser, "inherited");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                configurationContainer.setLocation((Object)"configuration", _location);
                configurationContainer.setConfiguration((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)configurationContainer, parser, "configuration");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)configurationContainer, parser);
        return configurationContainer;
    }

    private Contributor parseContributor(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Contributor contributor = new Contributor();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        contributor.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"name", _location);
                contributor.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)contributor, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "email", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"email", _location);
                contributor.setEmail(this.interpolatedTrimmed(parser.nextText(), "email"));
                this.setWrapLocation((InputLocationTracker)contributor, parser, "email");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"url", _location);
                contributor.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)contributor, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organization", "organisation", parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"organization", _location);
                contributor.setOrganization(this.interpolatedTrimmed(parser.nextText(), "organization"));
                this.setWrapLocation((InputLocationTracker)contributor, parser, "organization");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organizationUrl", "organisationUrl", parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"organizationUrl", _location);
                contributor.setOrganizationUrl(this.interpolatedTrimmed(parser.nextText(), "organizationUrl"));
                this.setWrapLocation((InputLocationTracker)contributor, parser, "organizationUrl");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"roles", _locations);
                while (parser.nextTag() == 2) {
                    if ("role".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)roles.size(), _location);
                        roles.add(this.interpolatedTrimmed(parser.nextText(), "roles"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, roles.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)contributor, parser, "roles");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "timezone", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"timezone", _location);
                contributor.setTimezone(this.interpolatedTrimmed(parser.nextText(), "timezone"));
                this.setWrapLocation((InputLocationTracker)contributor, parser, "timezone");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                contributor.setLocation((Object)"properties", _locations);
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                    _locations.setLocation((Object)key, _location);
                    String value = parser.nextText().trim();
                    contributor.addProperty(key, value);
                    this.setWrapLocation((InputLocationTracker)_locations, parser, key);
                }
                this.setWrapLocation((InputLocationTracker)contributor, parser, "properties");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)contributor, parser);
        return contributor;
    }

    private Dependency parseDependency(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Dependency dependency = new Dependency();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        dependency.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"groupId", _location);
                dependency.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"artifactId", _location);
                dependency.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "artifactId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"version", _location);
                dependency.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "version");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"type", _location);
                dependency.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "type");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "classifier", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"classifier", _location);
                dependency.setClassifier(this.interpolatedTrimmed(parser.nextText(), "classifier"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "classifier");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"scope", _location);
                dependency.setScope(this.interpolatedTrimmed(parser.nextText(), "scope"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "scope");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "systemPath", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"systemPath", _location);
                dependency.setSystemPath(this.interpolatedTrimmed(parser.nextText(), "systemPath"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "systemPath");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "exclusions", null, parsed)) {
                ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                dependency.setExclusions(exclusions);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"exclusions", _locations);
                while (parser.nextTag() == 2) {
                    if ("exclusion".equals(parser.getName())) {
                        exclusions.add(this.parseExclusion(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)dependency, parser, "exclusions");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "optional", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependency.setLocation((Object)"optional", _location);
                dependency.setOptional(this.interpolatedTrimmed(parser.nextText(), "optional"));
                this.setWrapLocation((InputLocationTracker)dependency, parser, "optional");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)dependency, parser);
        return dependency;
    }

    private DependencyManagement parseDependencyManagement(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DependencyManagement dependencyManagement = new DependencyManagement();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        dependencyManagement.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                dependencyManagement.setDependencies(dependencies);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                dependencyManagement.setLocation((Object)"dependencies", _locations);
                while (parser.nextTag() == 2) {
                    if ("dependency".equals(parser.getName())) {
                        dependencies.add(this.parseDependency(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)dependencyManagement, parser, "dependencies");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)dependencyManagement, parser);
        return dependencyManagement;
    }

    private DeploymentRepository parseDeploymentRepository(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DeploymentRepository deploymentRepository = new DeploymentRepository();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        deploymentRepository.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "uniqueVersion", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                deploymentRepository.setLocation((Object)"uniqueVersion", _location);
                deploymentRepository.setUniqueVersion(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "uniqueVersion"), "uniqueVersion", parser, "true"));
                this.setWrapLocation((InputLocationTracker)deploymentRepository, parser, "uniqueVersion");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "releases", null, parsed)) {
                deploymentRepository.setReleases(this.parseRepositoryPolicy(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshots", null, parsed)) {
                deploymentRepository.setSnapshots(this.parseRepositoryPolicy(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                deploymentRepository.setLocation((Object)"id", _location);
                deploymentRepository.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)deploymentRepository, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                deploymentRepository.setLocation((Object)"name", _location);
                deploymentRepository.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)deploymentRepository, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                deploymentRepository.setLocation((Object)"url", _location);
                deploymentRepository.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)deploymentRepository, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                deploymentRepository.setLocation((Object)"layout", _location);
                deploymentRepository.setLayout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                this.setWrapLocation((InputLocationTracker)deploymentRepository, parser, "layout");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return deploymentRepository;
    }

    private Developer parseDeveloper(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Developer developer = new Developer();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        developer.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"id", _location);
                developer.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)developer, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"name", _location);
                developer.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)developer, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "email", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"email", _location);
                developer.setEmail(this.interpolatedTrimmed(parser.nextText(), "email"));
                this.setWrapLocation((InputLocationTracker)developer, parser, "email");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"url", _location);
                developer.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)developer, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organization", "organisation", parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"organization", _location);
                developer.setOrganization(this.interpolatedTrimmed(parser.nextText(), "organization"));
                this.setWrapLocation((InputLocationTracker)developer, parser, "organization");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organizationUrl", "organisationUrl", parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"organizationUrl", _location);
                developer.setOrganizationUrl(this.interpolatedTrimmed(parser.nextText(), "organizationUrl"));
                this.setWrapLocation((InputLocationTracker)developer, parser, "organizationUrl");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"roles", _locations);
                while (parser.nextTag() == 2) {
                    if ("role".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)roles.size(), _location);
                        roles.add(this.interpolatedTrimmed(parser.nextText(), "roles"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, roles.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)developer, parser, "roles");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "timezone", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"timezone", _location);
                developer.setTimezone(this.interpolatedTrimmed(parser.nextText(), "timezone"));
                this.setWrapLocation((InputLocationTracker)developer, parser, "timezone");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                developer.setLocation((Object)"properties", _locations);
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                    _locations.setLocation((Object)key, _location);
                    String value = parser.nextText().trim();
                    developer.addProperty(key, value);
                    this.setWrapLocation((InputLocationTracker)_locations, parser, key);
                }
                this.setWrapLocation((InputLocationTracker)developer, parser, "properties");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)developer, parser);
        return developer;
    }

    private DistributionManagement parseDistributionManagement(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DistributionManagement distributionManagement = new DistributionManagement();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        distributionManagement.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "repository", null, parsed)) {
                distributionManagement.setRepository(this.parseDeploymentRepository(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshotRepository", null, parsed)) {
                distributionManagement.setSnapshotRepository(this.parseDeploymentRepository(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "site", null, parsed)) {
                distributionManagement.setSite(this.parseSite(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "downloadUrl", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                distributionManagement.setLocation((Object)"downloadUrl", _location);
                distributionManagement.setDownloadUrl(this.interpolatedTrimmed(parser.nextText(), "downloadUrl"));
                this.setWrapLocation((InputLocationTracker)distributionManagement, parser, "downloadUrl");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "relocation", null, parsed)) {
                distributionManagement.setRelocation(this.parseRelocation(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "status", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                distributionManagement.setLocation((Object)"status", _location);
                distributionManagement.setStatus(this.interpolatedTrimmed(parser.nextText(), "status"));
                this.setWrapLocation((InputLocationTracker)distributionManagement, parser, "status");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)distributionManagement, parser);
        return distributionManagement;
    }

    private Exclusion parseExclusion(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Exclusion exclusion = new Exclusion();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        exclusion.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                exclusion.setLocation((Object)"groupId", _location);
                exclusion.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)exclusion, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                exclusion.setLocation((Object)"artifactId", _location);
                exclusion.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)exclusion, parser, "artifactId");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)exclusion, parser);
        return exclusion;
    }

    private Extension parseExtension(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Extension extension = new Extension();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        extension.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                extension.setLocation((Object)"groupId", _location);
                extension.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)extension, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                extension.setLocation((Object)"artifactId", _location);
                extension.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)extension, parser, "artifactId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                extension.setLocation((Object)"version", _location);
                extension.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)extension, parser, "version");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)extension, parser);
        return extension;
    }

    private FileSet parseFileSet(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        FileSet fileSet = new FileSet();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        fileSet.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                fileSet.setLocation((Object)"directory", _location);
                fileSet.setDirectory(this.interpolatedTrimmed(parser.nextText(), "directory"));
                this.setWrapLocation((InputLocationTracker)fileSet, parser, "directory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                fileSet.setLocation((Object)"includes", _locations);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)includes.size(), _location);
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, includes.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)fileSet, parser, "includes");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                fileSet.setLocation((Object)"excludes", _locations);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)excludes.size(), _location);
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, excludes.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)fileSet, parser, "excludes");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)fileSet, parser);
        return fileSet;
    }

    private IssueManagement parseIssueManagement(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        IssueManagement issueManagement = new IssueManagement();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        issueManagement.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "system", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                issueManagement.setLocation((Object)"system", _location);
                issueManagement.setSystem(this.interpolatedTrimmed(parser.nextText(), "system"));
                this.setWrapLocation((InputLocationTracker)issueManagement, parser, "system");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                issueManagement.setLocation((Object)"url", _location);
                issueManagement.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)issueManagement, parser, "url");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)issueManagement, parser);
        return issueManagement;
    }

    private License parseLicense(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        License license = new License();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        license.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                license.setLocation((Object)"name", _location);
                license.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)license, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                license.setLocation((Object)"url", _location);
                license.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)license, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "distribution", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                license.setLocation((Object)"distribution", _location);
                license.setDistribution(this.interpolatedTrimmed(parser.nextText(), "distribution"));
                this.setWrapLocation((InputLocationTracker)license, parser, "distribution");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "comments", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                license.setLocation((Object)"comments", _location);
                license.setComments(this.interpolatedTrimmed(parser.nextText(), "comments"));
                this.setWrapLocation((InputLocationTracker)license, parser, "comments");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)license, parser);
        return license;
    }

    private MailingList parseMailingList(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MailingList mailingList = new MailingList();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        mailingList.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                mailingList.setLocation((Object)"name", _location);
                mailingList.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)mailingList, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "subscribe", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                mailingList.setLocation((Object)"subscribe", _location);
                mailingList.setSubscribe(this.interpolatedTrimmed(parser.nextText(), "subscribe"));
                this.setWrapLocation((InputLocationTracker)mailingList, parser, "subscribe");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unsubscribe", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                mailingList.setLocation((Object)"unsubscribe", _location);
                mailingList.setUnsubscribe(this.interpolatedTrimmed(parser.nextText(), "unsubscribe"));
                this.setWrapLocation((InputLocationTracker)mailingList, parser, "unsubscribe");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "post", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                mailingList.setLocation((Object)"post", _location);
                mailingList.setPost(this.interpolatedTrimmed(parser.nextText(), "post"));
                this.setWrapLocation((InputLocationTracker)mailingList, parser, "post");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "archive", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                mailingList.setLocation((Object)"archive", _location);
                mailingList.setArchive(this.interpolatedTrimmed(parser.nextText(), "archive"));
                this.setWrapLocation((InputLocationTracker)mailingList, parser, "archive");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "otherArchives", null, parsed)) {
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                mailingList.setLocation((Object)"otherArchives", _locations);
                while (parser.nextTag() == 2) {
                    if ("otherArchive".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)otherArchives.size(), _location);
                        otherArchives.add(this.interpolatedTrimmed(parser.nextText(), "otherArchives"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, otherArchives.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)mailingList, parser, "otherArchives");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)mailingList, parser);
        return mailingList;
    }

    private Model parseModel(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Model model = new Model();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        model.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("child.project.url.inherit.append.path".equals(name)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"childProjectUrlInheritAppendPath", _location);
                model.setChildProjectUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.project.url.inherit.append.path"));
                this.setWrapLocation((InputLocationTracker)model, parser, "childProjectUrlInheritAppendPath");
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "modelVersion", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"modelVersion", _location);
                model.setModelVersion(this.interpolatedTrimmed(parser.nextText(), "modelVersion"));
                this.setWrapLocation((InputLocationTracker)model, parser, "modelVersion");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "parent", null, parsed)) {
                model.setParent(this.parseParent(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"groupId", _location);
                model.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)model, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"artifactId", _location);
                model.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)model, parser, "artifactId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"version", _location);
                model.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)model, parser, "version");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "packaging", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"packaging", _location);
                model.setPackaging(this.interpolatedTrimmed(parser.nextText(), "packaging"));
                this.setWrapLocation((InputLocationTracker)model, parser, "packaging");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"name", _location);
                model.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)model, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"description", _location);
                model.setDescription(this.interpolatedTrimmed(parser.nextText(), "description"));
                this.setWrapLocation((InputLocationTracker)model, parser, "description");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"url", _location);
                model.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)model, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inceptionYear", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"inceptionYear", _location);
                model.setInceptionYear(this.interpolatedTrimmed(parser.nextText(), "inceptionYear"));
                this.setWrapLocation((InputLocationTracker)model, parser, "inceptionYear");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organization", "organisation", parsed)) {
                model.setOrganization(this.parseOrganization(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "licenses", null, parsed)) {
                ArrayList<License> licenses = new ArrayList<License>();
                model.setLicenses(licenses);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"licenses", _locations);
                while (parser.nextTag() == 2) {
                    if ("license".equals(parser.getName())) {
                        licenses.add(this.parseLicense(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "licenses");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "developers", null, parsed)) {
                ArrayList<Developer> developers = new ArrayList<Developer>();
                model.setDevelopers(developers);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"developers", _locations);
                while (parser.nextTag() == 2) {
                    if ("developer".equals(parser.getName())) {
                        developers.add(this.parseDeveloper(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "developers");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "contributors", null, parsed)) {
                ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                model.setContributors(contributors);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"contributors", _locations);
                while (parser.nextTag() == 2) {
                    if ("contributor".equals(parser.getName())) {
                        contributors.add(this.parseContributor(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "contributors");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mailingLists", null, parsed)) {
                ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                model.setMailingLists(mailingLists);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"mailingLists", _locations);
                while (parser.nextTag() == 2) {
                    if ("mailingList".equals(parser.getName())) {
                        mailingLists.add(this.parseMailingList(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "mailingLists");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "prerequisites", null, parsed)) {
                model.setPrerequisites(this.parsePrerequisites(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                model.setModules(modules);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"modules", _locations);
                while (parser.nextTag() == 2) {
                    if ("module".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)modules.size(), _location);
                        modules.add(this.interpolatedTrimmed(parser.nextText(), "modules"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, modules.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "modules");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scm", null, parsed)) {
                model.setScm(this.parseScm(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "issueManagement", null, parsed)) {
                model.setIssueManagement(this.parseIssueManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "ciManagement", null, parsed)) {
                model.setCiManagement(this.parseCiManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "distributionManagement", null, parsed)) {
                model.setDistributionManagement(this.parseDistributionManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                InputLocation _locations2 = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"properties", _locations2);
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                    _locations2.setLocation((Object)key, _location);
                    String value = parser.nextText().trim();
                    model.addProperty(key, value);
                    this.setWrapLocation((InputLocationTracker)_locations2, parser, key);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "properties");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencyManagement", null, parsed)) {
                model.setDependencyManagement(this.parseDependencyManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                model.setDependencies(dependencies);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"dependencies", _locations);
                while (parser.nextTag() == 2) {
                    if ("dependency".equals(parser.getName())) {
                        dependencies.add(this.parseDependency(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "dependencies");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                model.setRepositories(repositories);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"repositories", _locations);
                while (parser.nextTag() == 2) {
                    if ("repository".equals(parser.getName())) {
                        repositories.add(this.parseRepository(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "repositories");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                model.setPluginRepositories(pluginRepositories);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"pluginRepositories", _locations);
                while (parser.nextTag() == 2) {
                    if ("pluginRepository".equals(parser.getName())) {
                        pluginRepositories.add(this.parseRepository(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "pluginRepositories");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "build", null, parsed)) {
                model.setBuild(this.parseBuild(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"reports", _location);
                model.setReports((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)model, parser, "reports");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reporting", null, parsed)) {
                model.setReporting(this.parseReporting(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "profiles", null, parsed)) {
                ArrayList<Profile> profiles = new ArrayList<Profile>();
                model.setProfiles(profiles);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                model.setLocation((Object)"profiles", _locations);
                while (parser.nextTag() == 2) {
                    if ("profile".equals(parser.getName())) {
                        profiles.add(this.parseProfile(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)model, parser, "profiles");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)model, parser);
        return model;
    }

    private ModelBase parseModelBase(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ModelBase modelBase = new ModelBase();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        modelBase.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                modelBase.setModules(modules);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                modelBase.setLocation((Object)"modules", _locations);
                while (parser.nextTag() == 2) {
                    if ("module".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)modules.size(), _location);
                        modules.add(this.interpolatedTrimmed(parser.nextText(), "modules"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, modules.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)modelBase, parser, "modules");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "distributionManagement", null, parsed)) {
                modelBase.setDistributionManagement(this.parseDistributionManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                InputLocation _locations2 = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                modelBase.setLocation((Object)"properties", _locations2);
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                    _locations2.setLocation((Object)key, _location);
                    String value = parser.nextText().trim();
                    modelBase.addProperty(key, value);
                    this.setWrapLocation((InputLocationTracker)_locations2, parser, key);
                }
                this.setWrapLocation((InputLocationTracker)modelBase, parser, "properties");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencyManagement", null, parsed)) {
                modelBase.setDependencyManagement(this.parseDependencyManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                modelBase.setDependencies(dependencies);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                modelBase.setLocation((Object)"dependencies", _locations);
                while (parser.nextTag() == 2) {
                    if ("dependency".equals(parser.getName())) {
                        dependencies.add(this.parseDependency(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)modelBase, parser, "dependencies");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                modelBase.setRepositories(repositories);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                modelBase.setLocation((Object)"repositories", _locations);
                while (parser.nextTag() == 2) {
                    if ("repository".equals(parser.getName())) {
                        repositories.add(this.parseRepository(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)modelBase, parser, "repositories");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                modelBase.setPluginRepositories(pluginRepositories);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                modelBase.setLocation((Object)"pluginRepositories", _locations);
                while (parser.nextTag() == 2) {
                    if ("pluginRepository".equals(parser.getName())) {
                        pluginRepositories.add(this.parseRepository(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)modelBase, parser, "pluginRepositories");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                modelBase.setLocation((Object)"reports", _location);
                modelBase.setReports((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)modelBase, parser, "reports");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reporting", null, parsed)) {
                modelBase.setReporting(this.parseReporting(parser, strict, source));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)modelBase, parser);
        return modelBase;
    }

    private Notifier parseNotifier(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Notifier notifier = new Notifier();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        notifier.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                notifier.setLocation((Object)"type", _location);
                notifier.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                this.setWrapLocation((InputLocationTracker)notifier, parser, "type");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnError", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                notifier.setLocation((Object)"sendOnError", _location);
                notifier.setSendOnError(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "sendOnError"), "sendOnError", parser, "true"));
                this.setWrapLocation((InputLocationTracker)notifier, parser, "sendOnError");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnFailure", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                notifier.setLocation((Object)"sendOnFailure", _location);
                notifier.setSendOnFailure(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "sendOnFailure"), "sendOnFailure", parser, "true"));
                this.setWrapLocation((InputLocationTracker)notifier, parser, "sendOnFailure");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnSuccess", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                notifier.setLocation((Object)"sendOnSuccess", _location);
                notifier.setSendOnSuccess(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "sendOnSuccess"), "sendOnSuccess", parser, "true"));
                this.setWrapLocation((InputLocationTracker)notifier, parser, "sendOnSuccess");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnWarning", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                notifier.setLocation((Object)"sendOnWarning", _location);
                notifier.setSendOnWarning(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "sendOnWarning"), "sendOnWarning", parser, "true"));
                this.setWrapLocation((InputLocationTracker)notifier, parser, "sendOnWarning");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "address", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                notifier.setLocation((Object)"address", _location);
                notifier.setAddress(this.interpolatedTrimmed(parser.nextText(), "address"));
                this.setWrapLocation((InputLocationTracker)notifier, parser, "address");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                notifier.setLocation((Object)"configuration", _locations);
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                    _locations.setLocation((Object)key, _location);
                    String value = parser.nextText().trim();
                    notifier.addConfiguration(key, value);
                    this.setWrapLocation((InputLocationTracker)_locations, parser, key);
                }
                this.setWrapLocation((InputLocationTracker)notifier, parser, "configuration");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)notifier, parser);
        return notifier;
    }

    private Organization parseOrganization(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Organization organization = new Organization();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        organization.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                organization.setLocation((Object)"name", _location);
                organization.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)organization, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                organization.setLocation((Object)"url", _location);
                organization.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)organization, parser, "url");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)organization, parser);
        return organization;
    }

    private Parent parseParent(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Parent parent = new Parent();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        parent.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                parent.setLocation((Object)"groupId", _location);
                parent.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)parent, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                parent.setLocation((Object)"artifactId", _location);
                parent.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)parent, parser, "artifactId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                parent.setLocation((Object)"version", _location);
                parent.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)parent, parser, "version");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "relativePath", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                parent.setLocation((Object)"relativePath", _location);
                parent.setRelativePath(this.interpolatedTrimmed(parser.nextText(), "relativePath"));
                this.setWrapLocation((InputLocationTracker)parent, parser, "relativePath");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)parent, parser);
        return parent;
    }

    private PatternSet parsePatternSet(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PatternSet patternSet = new PatternSet();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        patternSet.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                patternSet.setLocation((Object)"includes", _locations);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)includes.size(), _location);
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, includes.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)patternSet, parser, "includes");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                patternSet.setLocation((Object)"excludes", _locations);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)excludes.size(), _location);
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, excludes.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)patternSet, parser, "excludes");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)patternSet, parser);
        return patternSet;
    }

    private Plugin parsePlugin(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Plugin plugin = new Plugin();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        plugin.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"groupId", _location);
                plugin.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)plugin, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"artifactId", _location);
                plugin.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)plugin, parser, "artifactId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"version", _location);
                plugin.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)plugin, parser, "version");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "extensions", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"extensions", _location);
                plugin.setExtensions(this.interpolatedTrimmed(parser.nextText(), "extensions"));
                this.setWrapLocation((InputLocationTracker)plugin, parser, "extensions");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executions", null, parsed)) {
                ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                plugin.setExecutions(executions);
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"executions", _location);
                while (parser.nextTag() == 2) {
                    if ("execution".equals(parser.getName())) {
                        executions.add(this.parsePluginExecution(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)plugin, parser, "executions");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                plugin.setDependencies(dependencies);
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"dependencies", _location);
                while (parser.nextTag() == 2) {
                    if ("dependency".equals(parser.getName())) {
                        dependencies.add(this.parseDependency(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)plugin, parser, "dependencies");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"goals", _location);
                plugin.setGoals((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)plugin, parser, "goals");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"inherited", _location);
                plugin.setInherited(this.interpolatedTrimmed(parser.nextText(), "inherited"));
                this.setWrapLocation((InputLocationTracker)plugin, parser, "inherited");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                plugin.setLocation((Object)"configuration", _location);
                plugin.setConfiguration((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)plugin, parser, "configuration");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)plugin, parser);
        return plugin;
    }

    private PluginConfiguration parsePluginConfiguration(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        pluginConfiguration.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "pluginManagement", null, parsed)) {
                pluginConfiguration.setPluginManagement(this.parsePluginManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginConfiguration.setPlugins(plugins);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginConfiguration.setLocation((Object)"plugins", _locations);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePlugin(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)pluginConfiguration, parser, "plugins");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)pluginConfiguration, parser);
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginContainer pluginContainer = new PluginContainer();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        pluginContainer.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginContainer.setPlugins(plugins);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginContainer.setLocation((Object)"plugins", _locations);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePlugin(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)pluginContainer, parser, "plugins");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)pluginContainer, parser);
        return pluginContainer;
    }

    private PluginExecution parsePluginExecution(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginExecution pluginExecution = new PluginExecution();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        pluginExecution.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginExecution.setLocation((Object)"id", _location);
                pluginExecution.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)pluginExecution, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phase", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginExecution.setLocation((Object)"phase", _location);
                pluginExecution.setPhase(this.interpolatedTrimmed(parser.nextText(), "phase"));
                this.setWrapLocation((InputLocationTracker)pluginExecution, parser, "phase");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                ArrayList<String> goals = new ArrayList<String>();
                pluginExecution.setGoals(goals);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginExecution.setLocation((Object)"goals", _locations);
                while (parser.nextTag() == 2) {
                    if ("goal".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)goals.size(), _location);
                        goals.add(this.interpolatedTrimmed(parser.nextText(), "goals"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, goals.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)pluginExecution, parser, "goals");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginExecution.setLocation((Object)"inherited", _location);
                pluginExecution.setInherited(this.interpolatedTrimmed(parser.nextText(), "inherited"));
                this.setWrapLocation((InputLocationTracker)pluginExecution, parser, "inherited");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginExecution.setLocation((Object)"configuration", _location);
                pluginExecution.setConfiguration((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)pluginExecution, parser, "configuration");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)pluginExecution, parser);
        return pluginExecution;
    }

    private PluginManagement parsePluginManagement(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginManagement pluginManagement = new PluginManagement();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        pluginManagement.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginManagement.setPlugins(plugins);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                pluginManagement.setLocation((Object)"plugins", _locations);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parsePlugin(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)pluginManagement, parser, "plugins");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)pluginManagement, parser);
        return pluginManagement;
    }

    private Prerequisites parsePrerequisites(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Prerequisites prerequisites = new Prerequisites();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        prerequisites.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "maven", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                prerequisites.setLocation((Object)"maven", _location);
                prerequisites.setMaven(this.interpolatedTrimmed(parser.nextText(), "maven"));
                this.setWrapLocation((InputLocationTracker)prerequisites, parser, "maven");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)prerequisites, parser);
        return prerequisites;
    }

    private Profile parseProfile(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Profile profile = new Profile();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        profile.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                profile.setLocation((Object)"id", _location);
                profile.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)profile, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "activation", null, parsed)) {
                profile.setActivation(this.parseActivation(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "build", null, parsed)) {
                profile.setBuild(this.parseBuildBase(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                profile.setModules(modules);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                profile.setLocation((Object)"modules", _locations);
                while (parser.nextTag() == 2) {
                    if ("module".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)modules.size(), _location);
                        modules.add(this.interpolatedTrimmed(parser.nextText(), "modules"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, modules.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)profile, parser, "modules");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "distributionManagement", null, parsed)) {
                profile.setDistributionManagement(this.parseDistributionManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                InputLocation _locations2 = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                profile.setLocation((Object)"properties", _locations2);
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                    _locations2.setLocation((Object)key, _location);
                    String value = parser.nextText().trim();
                    profile.addProperty(key, value);
                    this.setWrapLocation((InputLocationTracker)_locations2, parser, key);
                }
                this.setWrapLocation((InputLocationTracker)profile, parser, "properties");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencyManagement", null, parsed)) {
                profile.setDependencyManagement(this.parseDependencyManagement(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                profile.setDependencies(dependencies);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                profile.setLocation((Object)"dependencies", _locations);
                while (parser.nextTag() == 2) {
                    if ("dependency".equals(parser.getName())) {
                        dependencies.add(this.parseDependency(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)profile, parser, "dependencies");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                profile.setLocation((Object)"repositories", _locations);
                while (parser.nextTag() == 2) {
                    if ("repository".equals(parser.getName())) {
                        repositories.add(this.parseRepository(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)profile, parser, "repositories");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                profile.setLocation((Object)"pluginRepositories", _locations);
                while (parser.nextTag() == 2) {
                    if ("pluginRepository".equals(parser.getName())) {
                        pluginRepositories.add(this.parseRepository(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)profile, parser, "pluginRepositories");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                profile.setLocation((Object)"reports", _location);
                profile.setReports((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)profile, parser, "reports");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reporting", null, parsed)) {
                profile.setReporting(this.parseReporting(parser, strict, source));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)profile, parser);
        return profile;
    }

    private Relocation parseRelocation(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Relocation relocation = new Relocation();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        relocation.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                relocation.setLocation((Object)"groupId", _location);
                relocation.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)relocation, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                relocation.setLocation((Object)"artifactId", _location);
                relocation.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)relocation, parser, "artifactId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                relocation.setLocation((Object)"version", _location);
                relocation.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)relocation, parser, "version");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "message", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                relocation.setLocation((Object)"message", _location);
                relocation.setMessage(this.interpolatedTrimmed(parser.nextText(), "message"));
                this.setWrapLocation((InputLocationTracker)relocation, parser, "message");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)relocation, parser);
        return relocation;
    }

    private ReportPlugin parseReportPlugin(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ReportPlugin reportPlugin = new ReportPlugin();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        reportPlugin.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportPlugin.setLocation((Object)"groupId", _location);
                reportPlugin.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                this.setWrapLocation((InputLocationTracker)reportPlugin, parser, "groupId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportPlugin.setLocation((Object)"artifactId", _location);
                reportPlugin.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                this.setWrapLocation((InputLocationTracker)reportPlugin, parser, "artifactId");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportPlugin.setLocation((Object)"version", _location);
                reportPlugin.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                this.setWrapLocation((InputLocationTracker)reportPlugin, parser, "version");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reportSets", null, parsed)) {
                ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                reportPlugin.setReportSets(reportSets);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportPlugin.setLocation((Object)"reportSets", _locations);
                while (parser.nextTag() == 2) {
                    if ("reportSet".equals(parser.getName())) {
                        reportSets.add(this.parseReportSet(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)reportPlugin, parser, "reportSets");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportPlugin.setLocation((Object)"inherited", _location);
                reportPlugin.setInherited(this.interpolatedTrimmed(parser.nextText(), "inherited"));
                this.setWrapLocation((InputLocationTracker)reportPlugin, parser, "inherited");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportPlugin.setLocation((Object)"configuration", _location);
                reportPlugin.setConfiguration((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)reportPlugin, parser, "configuration");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)reportPlugin, parser);
        return reportPlugin;
    }

    private ReportSet parseReportSet(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ReportSet reportSet = new ReportSet();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        reportSet.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportSet.setLocation((Object)"id", _location);
                reportSet.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)reportSet, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                ArrayList<String> reports = new ArrayList<String>();
                reportSet.setReports(reports);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportSet.setLocation((Object)"reports", _locations);
                while (parser.nextTag() == 2) {
                    if ("report".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)reports.size(), _location);
                        reports.add(this.interpolatedTrimmed(parser.nextText(), "reports"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, reports.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)reportSet, parser, "reports");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportSet.setLocation((Object)"inherited", _location);
                reportSet.setInherited(this.interpolatedTrimmed(parser.nextText(), "inherited"));
                this.setWrapLocation((InputLocationTracker)reportSet, parser, "inherited");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reportSet.setLocation((Object)"configuration", _location);
                reportSet.setConfiguration((Object)Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                this.setWrapLocation((InputLocationTracker)reportSet, parser, "configuration");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)reportSet, parser);
        return reportSet;
    }

    private Reporting parseReporting(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Reporting reporting = new Reporting();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        reporting.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "excludeDefaults", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reporting.setLocation((Object)"excludeDefaults", _location);
                reporting.setExcludeDefaults(this.interpolatedTrimmed(parser.nextText(), "excludeDefaults"));
                this.setWrapLocation((InputLocationTracker)reporting, parser, "excludeDefaults");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reporting.setLocation((Object)"outputDirectory", _location);
                reporting.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                this.setWrapLocation((InputLocationTracker)reporting, parser, "outputDirectory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                reporting.setPlugins(plugins);
                InputLocation _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                reporting.setLocation((Object)"plugins", _locations);
                while (parser.nextTag() == 2) {
                    if ("plugin".equals(parser.getName())) {
                        plugins.add(this.parseReportPlugin(parser, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)reporting, parser, "plugins");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)reporting, parser);
        return reporting;
    }

    private Repository parseRepository(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Repository repository = new Repository();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        repository.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "releases", null, parsed)) {
                repository.setReleases(this.parseRepositoryPolicy(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshots", null, parsed)) {
                repository.setSnapshots(this.parseRepositoryPolicy(parser, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repository.setLocation((Object)"id", _location);
                repository.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)repository, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repository.setLocation((Object)"name", _location);
                repository.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)repository, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repository.setLocation((Object)"url", _location);
                repository.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)repository, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repository.setLocation((Object)"layout", _location);
                repository.setLayout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                this.setWrapLocation((InputLocationTracker)repository, parser, "layout");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)repository, parser);
        return repository;
    }

    private RepositoryBase parseRepositoryBase(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryBase repositoryBase = new RepositoryBase();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        repositoryBase.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repositoryBase.setLocation((Object)"id", _location);
                repositoryBase.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)repositoryBase, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repositoryBase.setLocation((Object)"name", _location);
                repositoryBase.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)repositoryBase, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repositoryBase.setLocation((Object)"url", _location);
                repositoryBase.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)repositoryBase, parser, "url");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repositoryBase.setLocation((Object)"layout", _location);
                repositoryBase.setLayout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                this.setWrapLocation((InputLocationTracker)repositoryBase, parser, "layout");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)repositoryBase, parser);
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        repositoryPolicy.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repositoryPolicy.setLocation((Object)"enabled", _location);
                repositoryPolicy.setEnabled(this.interpolatedTrimmed(parser.nextText(), "enabled"));
                this.setWrapLocation((InputLocationTracker)repositoryPolicy, parser, "enabled");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updatePolicy", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repositoryPolicy.setLocation((Object)"updatePolicy", _location);
                repositoryPolicy.setUpdatePolicy(this.interpolatedTrimmed(parser.nextText(), "updatePolicy"));
                this.setWrapLocation((InputLocationTracker)repositoryPolicy, parser, "updatePolicy");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "checksumPolicy", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                repositoryPolicy.setLocation((Object)"checksumPolicy", _location);
                repositoryPolicy.setChecksumPolicy(this.interpolatedTrimmed(parser.nextText(), "checksumPolicy"));
                this.setWrapLocation((InputLocationTracker)repositoryPolicy, parser, "checksumPolicy");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)repositoryPolicy, parser);
        return repositoryPolicy;
    }

    private Resource parseResource(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Resource resource = new Resource();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        resource.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser, "targetPath", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                resource.setLocation((Object)"targetPath", _location);
                resource.setTargetPath(this.interpolatedTrimmed(parser.nextText(), "targetPath"));
                this.setWrapLocation((InputLocationTracker)resource, parser, "targetPath");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtering", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                resource.setLocation((Object)"filtering", _location);
                resource.setFiltering(this.interpolatedTrimmed(parser.nextText(), "filtering"));
                this.setWrapLocation((InputLocationTracker)resource, parser, "filtering");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                resource.setLocation((Object)"directory", _location);
                resource.setDirectory(this.interpolatedTrimmed(parser.nextText(), "directory"));
                this.setWrapLocation((InputLocationTracker)resource, parser, "directory");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                resource.setLocation((Object)"includes", _locations);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)includes.size(), _location);
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, includes.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)resource, parser, "includes");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                _locations = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                resource.setLocation((Object)"excludes", _locations);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                        _locations.setLocation((Object)excludes.size(), _location);
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        this.setWrapLocation((InputLocationTracker)_locations, parser, excludes.size() - 1);
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                this.setWrapLocation((InputLocationTracker)resource, parser, "excludes");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)resource, parser);
        return resource;
    }

    private Scm parseScm(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Scm scm = new Scm();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        scm.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("child.scm.connection.inherit.append.path".equals(name)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                scm.setLocation((Object)"childScmConnectionInheritAppendPath", _location);
                scm.setChildScmConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.connection.inherit.append.path"));
                this.setWrapLocation((InputLocationTracker)scm, parser, "childScmConnectionInheritAppendPath");
                continue;
            }
            if ("child.scm.developerConnection.inherit.append.path".equals(name)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                scm.setLocation((Object)"childScmDeveloperConnectionInheritAppendPath", _location);
                scm.setChildScmDeveloperConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.developerConnection.inherit.append.path"));
                this.setWrapLocation((InputLocationTracker)scm, parser, "childScmDeveloperConnectionInheritAppendPath");
                continue;
            }
            if ("child.scm.url.inherit.append.path".equals(name)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                scm.setLocation((Object)"childScmUrlInheritAppendPath", _location);
                scm.setChildScmUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.url.inherit.append.path"));
                this.setWrapLocation((InputLocationTracker)scm, parser, "childScmUrlInheritAppendPath");
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "connection", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                scm.setLocation((Object)"connection", _location);
                scm.setConnection(this.interpolatedTrimmed(parser.nextText(), "connection"));
                this.setWrapLocation((InputLocationTracker)scm, parser, "connection");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "developerConnection", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                scm.setLocation((Object)"developerConnection", _location);
                scm.setDeveloperConnection(this.interpolatedTrimmed(parser.nextText(), "developerConnection"));
                this.setWrapLocation((InputLocationTracker)scm, parser, "developerConnection");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "tag", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                scm.setLocation((Object)"tag", _location);
                scm.setTag(this.interpolatedTrimmed(parser.nextText(), "tag"));
                this.setWrapLocation((InputLocationTracker)scm, parser, "tag");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                scm.setLocation((Object)"url", _location);
                scm.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)scm, parser, "url");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)scm, parser);
        return scm;
    }

    private Site parseSite(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Site site = new Site();
        InputLocation _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
        site.setLocation((Object)"", _location);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("child.site.url.inherit.append.path".equals(name)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                site.setLocation((Object)"childSiteUrlInheritAppendPath", _location);
                site.setChildSiteUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.site.url.inherit.append.path"));
                this.setWrapLocation((InputLocationTracker)site, parser, "childSiteUrlInheritAppendPath");
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                site.setLocation((Object)"id", _location);
                site.setId(this.interpolatedTrimmed(parser.nextText(), "id"));
                this.setWrapLocation((InputLocationTracker)site, parser, "id");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                site.setLocation((Object)"name", _location);
                site.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                this.setWrapLocation((InputLocationTracker)site, parser, "name");
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                _location = new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source);
                site.setLocation((Object)"url", _location);
                site.setUrl(this.interpolatedTrimmed(parser.nextText(), "url"));
                this.setWrapLocation((InputLocationTracker)site, parser, "url");
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        this.setWrapLocation((InputLocationTracker)site, parser);
        return site;
    }

    private Model read(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        Model model = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"project".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'project' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'project'", parser, null);
                }
                model = this.parseModel(parser, strict, source);
                model.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return model;
        }
        throw new XmlPullParserException("Expected root element 'project' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    private void setWrapLocation(InputLocationTracker element, XmlPullParser parser, Object key) {
        int line = parser.getLineNumber();
        int col = parser.getColumnNumber();
        element.setLocation((Object)(String.valueOf(key) + END), new InputLocation(line, col));
        InputLocation endOfStart = element.getLocation(key);
        line = endOfStart.getLineNumber();
        col = endOfStart.getColumnNumber() - parser.getName().length() - 2;
        element.setLocation((Object)(String.valueOf(key) + START), new InputLocation(line, col));
    }

    private void setWrapLocation(InputLocationTracker element, XmlPullParser parser) {
        this.setWrapLocation(element, parser, "");
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }

    private static class Xpp3DomBuilderInputLocationBuilder
    implements Xpp3DomBuilder.InputLocationBuilder {
        private final InputLocation rootLocation;

        public Xpp3DomBuilderInputLocationBuilder(InputLocation rootLocation) {
            this.rootLocation = rootLocation;
        }

        public Object toInputLocation(XmlPullParser parser) {
            return new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), this.rootLocation.getSource());
        }
    }
}

