/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.test.utils.tests;

import io.cucumber.java.After;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.technologybrewery.fermenter.mda.element.ExpandedProfile;
import org.technologybrewery.fermenter.mda.element.Target;
import org.technologybrewery.fermenter.mda.test.utils.FermenterMDATestUtil;

public class ProfileSteps {
    private File profilesFile;
    private File targetsFile;
    private Map<String, ExpandedProfile> loadedProfiles = new HashMap<String, ExpandedProfile>();
    private Map<String, Target> loadedTargets = new HashMap<String, Target>();

    @After(value="@profile")
    public void cleanUp() {
        this.profilesFile = null;
        this.loadedProfiles.clear();
    }

    @Given(value="profiles are loaded from {string} and targets are loaded from {string}")
    public void profiles_targets_loaded(String profilePath, String targetPath) throws Throwable {
        this.profilesFile = new File(profilePath);
        Assertions.assertTrue((boolean)this.profilesFile.exists(), (String)"profiles.json file not found!");
        this.targetsFile = new File(targetPath);
        Assertions.assertTrue((boolean)this.targetsFile.exists(), (String)"targets.json file not found!");
    }

    @When(value="profiles and targets are read")
    public void profiles_are_read() throws IOException {
        Pair profilesAndTarget = FermenterMDATestUtil.readProfilesAndTargetFile((File)this.profilesFile, (File)this.targetsFile);
        this.loadedProfiles = (Map)profilesAndTarget.getLeft();
        this.loadedTargets = (Map)profilesAndTarget.getRight();
        Assertions.assertNotNull(this.loadedProfiles, (String)"Could not read profile file!");
        Assertions.assertNotNull(this.loadedTargets, (String)"Could not read targets file!");
    }

    @Then(value="a valid profile {string} is available and target references \"{listOfStrings}\" are contained")
    public void profile_contains_target_references(String expectedProfileName, List<String> targetReferences) {
        ExpandedProfile profile = this.loadedProfiles.get(expectedProfileName);
        Assertions.assertNotNull((Object)profile, (String)"Could not find the profile!");
        List missingTargets = FermenterMDATestUtil.retriveMissingTargets((ExpandedProfile)profile, targetReferences);
        Assertions.assertTrue((boolean)missingTargets.isEmpty(), (String)("Could not find all target references specified. Missing Target References are: " + missingTargets));
    }

    @Then(value="a valid profile {string} is available and target reference is empty")
    public void profile_have_empty_target(String expectedProfileName) {
        ExpandedProfile profile = this.loadedProfiles.get(expectedProfileName);
        Assertions.assertNotNull((Object)profile, (String)"Could not find the profile!");
        Assertions.assertTrue((boolean)profile.getTargets().isEmpty(), (String)"Expected empty target reference but found target references");
    }

    @Then(value="a valid profile {string} is available and other profile references \"{listOfStrings}\" are contained")
    public void profile_contains_profile_references(String expectedProfileName, List<String> profileReferences) {
        ExpandedProfile profile = this.loadedProfiles.get(expectedProfileName);
        Assertions.assertNotNull((Object)profile, (String)"Could not find the profile!");
        List missingProfiles = FermenterMDATestUtil.retrieveMissingProfiles((ExpandedProfile)profile, profileReferences);
        Assertions.assertTrue((boolean)missingProfiles.isEmpty(), (String)("Could not find all profile references specified. Missing Profile References are : " + missingProfiles));
    }

    @Then(value="a valid profile {string} is available and other profile reference is empty")
    public void profile_have_empty_profile_ref(String expectedProfileName) {
        ExpandedProfile profile = this.loadedProfiles.get(expectedProfileName);
        Assertions.assertNotNull((Object)profile, (String)"Could not find the profile!");
        Assertions.assertTrue((boolean)profile.getReferencedProfiles().isEmpty(), (String)"Expected empty profile reference but found profile references");
    }

    @Then(value="a valid profile {string} is available and profile is not deprecated")
    public void profile_not_deprecated(String expectedProfileName) {
        ExpandedProfile profile = this.loadedProfiles.get(expectedProfileName);
        Assertions.assertNotNull((Object)profile, (String)"Could not find the profile!");
        Assertions.assertFalse((boolean)profile.isDeprecated(), (String)"Profile is deprecated");
    }

    @Then(value="a valid profile {string} is available and profile is deprecated")
    public void profile_deprecated(String expectedProfileName) {
        ExpandedProfile profile = this.loadedProfiles.get(expectedProfileName);
        Assertions.assertNotNull((Object)profile, (String)"Could not find the profile!");
        Assertions.assertTrue((boolean)profile.isDeprecated(), (String)"Profile is not deprecated");
    }
}

