/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.test.utils.tests;

import io.cucumber.java.After;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.technologybrewery.fermenter.mda.GenerateSourcesHelper;
import org.technologybrewery.fermenter.mda.element.Target;
import org.technologybrewery.fermenter.mda.test.utils.FermenterMDATestUtil;

public class TargetSteps {
    private File targetFile;
    private Map<String, Target> loadedTargets = new HashMap<String, Target>();

    @After(value="@target")
    public void cleanUp() {
        this.targetFile = null;
        this.loadedTargets.clear();
    }

    @Given(value="targets are loaded from {string}")
    public void targets_loaded(String targetPath) {
        this.targetFile = new File(targetPath);
        Assertions.assertTrue((boolean)this.targetFile.exists(), (String)"targets.json does not exist!");
    }

    @When(value="targets are read")
    public void targets_are_read() throws IOException {
        FileInputStream targetStream = new FileInputStream(this.targetFile);
        this.loadedTargets = GenerateSourcesHelper.loadTargets((InputStream)targetStream, this.loadedTargets);
        Assertions.assertNotNull(this.loadedTargets, (String)"Could not read targets.json file!");
    }

    @Then(value="a valid target {string} is available")
    public void targets_contain_specified_target(String expectedTargetName) {
        Target target = this.loadedTargets.get(expectedTargetName);
        Assertions.assertNotNull((Object)target, (String)"Could not find target specified");
    }

    @Then(value="an invalid target {string} is not available")
    public void targets_does_not_contain_specified_target(String expectedTargetName) {
        Target target = this.loadedTargets.get(expectedTargetName);
        Assertions.assertNull((Object)target, (String)"Found the invalid target specified");
    }

    @Then(value="a valid target {string} is available and valid template file exists")
    public void targets_contains_template_file(String expectedTargetName) {
        Target target = this.loadedTargets.get(expectedTargetName);
        Assertions.assertNotNull((Object)target, (String)"Could not find the target!");
        String baseDirectory = "src/test/resources/";
        Assertions.assertTrue((boolean)FermenterMDATestUtil.isTemplateFileExist((Target)target, (String)baseDirectory), (String)"Template File Does not Exist!");
    }

    @Then(value="a valid target {string} is available and invalid template file does not exist")
    public void targets_does_not_contains_template_file(String expectedTargetName) {
        Target target = this.loadedTargets.get(expectedTargetName);
        Assertions.assertNotNull((Object)target, (String)"Could not find the target!");
        String baseDirectory = "src/test/resources/";
        Assertions.assertFalse((boolean)FermenterMDATestUtil.isTemplateFileExist((Target)target, (String)baseDirectory), (String)"Invalid Template File Does not Exist!");
    }

    @Then(value="a valid target {string} is available and valid generator file exists")
    public void target_contains_generator_file(String expectedTargetName) {
        Target target = this.loadedTargets.get(expectedTargetName);
        Assertions.assertNotNull((Object)target, (String)"Could not find the target!");
        Assertions.assertTrue((boolean)FermenterMDATestUtil.isGeneratorOnClassPath((Target)target), (String)"Generator File Does not Exist!");
    }

    @Then(value="a valid target {string} is available and invalid generator file does not exist")
    public void target_does_not_contain_generator_file(String expectedTargetName) {
        Target target = this.loadedTargets.get(expectedTargetName);
        Assertions.assertNotNull((Object)target, (String)"Could not find the target!");
        Assertions.assertFalse((boolean)FermenterMDATestUtil.isGeneratorOnClassPath((Target)target), (String)"Invalid Generator File Exist!");
    }
}

