/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.test.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.technologybrewery.fermenter.mda.GenerateSourcesHelper;
import org.technologybrewery.fermenter.mda.element.ExpandedProfile;
import org.technologybrewery.fermenter.mda.element.Target;

public class FermenterMDATestUtil {
    public static Pair<Map<String, ExpandedProfile>, Map<String, Target>> readProfilesAndTargetFile(File profilesFile, File targetsFile) throws IOException {
        Map<String, ExpandedProfile> profilesMap = FermenterMDATestUtil.readProfilesFile(profilesFile);
        Map<String, Target> targetsMap = FermenterMDATestUtil.readTargetsFile(targetsFile);
        for (ExpandedProfile p : profilesMap.values()) {
            p.dereference(profilesMap, targetsMap);
        }
        return Pair.of(profilesMap, targetsMap);
    }

    public static Map<String, ExpandedProfile> readProfilesFile(File profilesFile) throws IOException {
        HashMap<String, ExpandedProfile> profilesMap = new HashMap();
        FileInputStream profileStream = new FileInputStream(profilesFile);
        profilesMap = GenerateSourcesHelper.loadProfiles((InputStream)profileStream, profilesMap);
        return profilesMap;
    }

    public static Map<String, Target> readTargetsFile(File targetsFile) throws IOException {
        HashMap<String, Target> targetsMap = new HashMap();
        FileInputStream targetStream = new FileInputStream(targetsFile);
        targetsMap = GenerateSourcesHelper.loadTargets((InputStream)targetStream, targetsMap);
        return targetsMap;
    }

    public static List<String> retriveMissingTargets(ExpandedProfile profile, List<String> targetReferences) {
        List profileTargetReferences = profile.getTargets().stream().map(Target::getName).collect(Collectors.toList());
        ArrayList<String> missingTargets = new ArrayList<String>(CollectionUtils.removeAll(targetReferences, profileTargetReferences));
        return missingTargets;
    }

    public static List<String> retrieveMissingProfiles(ExpandedProfile profile, List<String> profileReferences) {
        List profileProfileReferences = profile.getReferencedProfiles().stream().map(ExpandedProfile::getName).collect(Collectors.toList());
        ArrayList<String> missingProfiles = new ArrayList<String>(CollectionUtils.removeAll(profileReferences, profileProfileReferences));
        return missingProfiles;
    }

    public static boolean isTemplateFileExist(Target target, String baseDirectory) {
        String fullTemplateFilePath = baseDirectory + target.getTemplateName();
        File templateFile = new File(fullTemplateFilePath);
        return templateFile.exists();
    }

    public static boolean isGeneratorOnClassPath(Target target) {
        try {
            Class.forName(target.getGenerator());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

