/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.authn;

import io.buji.pac4j.subject.Pac4jPrincipal;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.exception.UnrecoverableException;

public class IdentityManager {
    private static final Logger logger = LoggerFactory.getLogger(IdentityManager.class);

    public String getSubjectName() {
        String subjectName = null;
        Subject subject = SecurityUtils.getSubject();
        Object principal = subject.getPrincipal();
        if (principal != null) {
            if (principal instanceof Pac4jPrincipal) {
                Pac4jPrincipal pac4JPrincipal = (Pac4jPrincipal)principal;
                CommonProfile profile = pac4JPrincipal.getProfile();
                subjectName = profile.getUsername();
                if (subjectName == null) {
                    subjectName = profile.getId();
                }
            } else if (principal instanceof String) {
                subjectName = (String)principal;
            } else {
                throw new UnrecoverableException("Unknown type of principal: " + principal.getClass());
            }
            if (!subject.isAuthenticated()) {
                logger.warn("User {} has been logged out!", (Object)subjectName);
                subjectName = null;
            }
        }
        return subjectName;
    }

    public void logout() {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            subject.logout();
        } else {
            logger.warn("Cannot logout when subject {} is already logged out!", (Object)this.getSubjectName());
        }
    }
}

