/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.authn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.matching.checker.MatchingChecker;
import org.pac4j.core.matching.matcher.CacheControlMatcher;
import org.pac4j.core.matching.matcher.CorsMatcher;
import org.pac4j.core.matching.matcher.HttpMethodMatcher;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.matching.matcher.StrictTransportSecurityMatcher;
import org.pac4j.core.matching.matcher.XContentTypeOptionsMatcher;
import org.pac4j.core.matching.matcher.XFrameOptionsMatcher;
import org.pac4j.core.matching.matcher.XSSProtectionMatcher;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGenerator;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGeneratorMatcher;
import org.pac4j.core.matching.matcher.csrf.DefaultCsrfTokenGenerator;
import org.pac4j.core.util.CommonHelper;

public class ModifiedDefaultMatchingChecker
implements MatchingChecker {
    private static final Matcher GET_MATCHER = new HttpMethodMatcher(new HttpConstants.HTTP_METHOD[]{HttpConstants.HTTP_METHOD.GET});
    private static final Matcher POST_MATCHER = new HttpMethodMatcher(new HttpConstants.HTTP_METHOD[]{HttpConstants.HTTP_METHOD.POST});
    private static final Matcher PUT_MATCHER = new HttpMethodMatcher(new HttpConstants.HTTP_METHOD[]{HttpConstants.HTTP_METHOD.PUT});
    private static final Matcher DELETE_MATCHER = new HttpMethodMatcher(new HttpConstants.HTTP_METHOD[]{HttpConstants.HTTP_METHOD.DELETE});
    static final StrictTransportSecurityMatcher STRICT_TRANSPORT_MATCHER = new StrictTransportSecurityMatcher();
    static final XContentTypeOptionsMatcher X_CONTENT_TYPE_OPTIONS_MATCHER = new XContentTypeOptionsMatcher();
    static final XFrameOptionsMatcher X_FRAME_OPTIONS_MATCHER = new XFrameOptionsMatcher();
    static final XSSProtectionMatcher XSS_PROTECTION_MATCHER = new XSSProtectionMatcher();
    static final CacheControlMatcher CACHE_CONTROL_MATCHER = new CacheControlMatcher();
    static final CsrfTokenGeneratorMatcher CSRF_TOKEN_MATCHER = new CsrfTokenGeneratorMatcher((CsrfTokenGenerator)new DefaultCsrfTokenGenerator());
    static final CorsMatcher CORS_MATCHER = new CorsMatcher();

    /*
     * WARNING - void declaration
     */
    public boolean matches(WebContext context, String matchersValue, Map<String, Matcher> matchersMap) {
        String matcherNames = matchersValue;
        if (CommonHelper.isBlank((String)matcherNames)) {
            matcherNames = "securityheaders,csrfToken";
        }
        ArrayList<Object> matchers = new ArrayList<Object>();
        CommonHelper.assertNotNull((String)"matchersMap", matchersMap);
        Map<String, Matcher> allMatchers = this.buildAllMatchers(matchersMap);
        String[] names = matcherNames.split(",");
        int nb = names.length;
        for (int i = 0; i < nb; ++i) {
            void var10_11;
            String string = names[i].trim();
            if (string.indexOf(":") != -1) {
                String string2 = this.convertNameFromMapEntryToString(string);
            }
            if ("hsts".equalsIgnoreCase((String)var10_11)) {
                matchers.add(STRICT_TRANSPORT_MATCHER);
                continue;
            }
            if ("nosniff".equalsIgnoreCase((String)var10_11)) {
                matchers.add(X_CONTENT_TYPE_OPTIONS_MATCHER);
                continue;
            }
            if ("noframe".equalsIgnoreCase((String)var10_11)) {
                matchers.add(X_FRAME_OPTIONS_MATCHER);
                continue;
            }
            if ("xssprotection".equalsIgnoreCase((String)var10_11)) {
                matchers.add(XSS_PROTECTION_MATCHER);
                continue;
            }
            if ("nocache".equalsIgnoreCase((String)var10_11)) {
                matchers.add(CACHE_CONTROL_MATCHER);
                continue;
            }
            if ("securityheaders".equalsIgnoreCase((String)var10_11)) {
                matchers.add(CACHE_CONTROL_MATCHER);
                matchers.add(X_CONTENT_TYPE_OPTIONS_MATCHER);
                matchers.add(STRICT_TRANSPORT_MATCHER);
                matchers.add(X_FRAME_OPTIONS_MATCHER);
                matchers.add(XSS_PROTECTION_MATCHER);
                continue;
            }
            if ("csrfToken".equalsIgnoreCase((String)var10_11)) {
                matchers.add(CSRF_TOKEN_MATCHER);
                continue;
            }
            if ("allowAjaxRequests".equalsIgnoreCase((String)var10_11)) {
                matchers.add(CORS_MATCHER);
                continue;
            }
            if ("none".equalsIgnoreCase((String)var10_11)) continue;
            Matcher result = null;
            for (Map.Entry<String, Matcher> entry : allMatchers.entrySet()) {
                if (!CommonHelper.areEqualsIgnoreCaseAndTrim((String)entry.getKey(), (String)var10_11)) continue;
                result = entry.getValue();
                break;
            }
            CommonHelper.assertNotNull((String)("allMatchers['" + (String)var10_11 + "']"), result);
            matchers.add(result);
        }
        if (!matchers.isEmpty()) {
            for (Matcher matcher : matchers) {
                if (matcher.matches(context)) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, Matcher> buildAllMatchers(Map<String, Matcher> matchersMap) {
        HashMap<String, Matcher> allMatchers = new HashMap<String, Matcher>();
        allMatchers.putAll(matchersMap);
        this.addDefaultMatcherIfNotDefined(allMatchers, "get", GET_MATCHER);
        this.addDefaultMatcherIfNotDefined(allMatchers, "post", POST_MATCHER);
        this.addDefaultMatcherIfNotDefined(allMatchers, "put", PUT_MATCHER);
        this.addDefaultMatcherIfNotDefined(allMatchers, "delete", DELETE_MATCHER);
        return allMatchers;
    }

    private void addDefaultMatcherIfNotDefined(Map<String, Matcher> allMatchers, String name, Matcher matcher) {
        if (!allMatchers.containsKey(name)) {
            allMatchers.put(name, matcher);
        }
    }

    private String convertNameFromMapEntryToString(String nameToModify) {
        String[] keyValuePair = nameToModify.split(":");
        CommonHelper.assertTrue((keyValuePair.length == 2 ? 1 : 0) != 0, (String)("Key/value pair not correctly parsed for matcher name " + nameToModify + "!"));
        return keyValuePair[0];
    }

    static {
        CORS_MATCHER.setAllowOrigin("*");
        CORS_MATCHER.setAllowCredentials(Boolean.valueOf(true));
        HashSet<HttpConstants.HTTP_METHOD> methods = new HashSet<HttpConstants.HTTP_METHOD>();
        methods.add(HttpConstants.HTTP_METHOD.GET);
        methods.add(HttpConstants.HTTP_METHOD.PUT);
        methods.add(HttpConstants.HTTP_METHOD.POST);
        methods.add(HttpConstants.HTTP_METHOD.DELETE);
        methods.add(HttpConstants.HTTP_METHOD.OPTIONS);
        CORS_MATCHER.setAllowMethods(methods);
    }
}

