/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.authz;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.ow2.authzforce.core.pdp.api.XmlUtils;
import org.ow2.authzforce.core.pdp.api.value.AnyUriValue;
import org.ow2.authzforce.core.pdp.api.value.BooleanValue;
import org.ow2.authzforce.core.pdp.api.value.DateValue;
import org.ow2.authzforce.core.pdp.api.value.DoubleValue;
import org.ow2.authzforce.core.pdp.api.value.GenericInteger;
import org.ow2.authzforce.core.pdp.api.value.IntegerValue;
import org.ow2.authzforce.core.pdp.api.value.MediumInteger;
import org.ow2.authzforce.core.pdp.api.value.StringValue;

public class AttributeValue<T> {
    private String attributeId;
    private T value;

    public AttributeValue(String attributeId, T value) {
        this.attributeId = attributeId;
        this.value = value;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public T getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.value != null ? this.value.toString() : null;
    }

    public StringValue getAsStringValue() {
        return this.value != null ? new StringValue(this.value.toString()) : null;
    }

    public IntegerValue getAsIntegerValue() {
        Integer valueAsInteger = (Integer)this.value;
        return valueAsInteger != null ? new IntegerValue((GenericInteger)new MediumInteger(valueAsInteger.intValue())) : null;
    }

    public DoubleValue getAsDoubleValue() {
        Double valueAsDouble = (Double)this.value;
        return valueAsDouble != null ? new DoubleValue(valueAsDouble) : null;
    }

    public AnyUriValue getAsAnyUriValue() {
        return this.value != null ? new AnyUriValue(this.value.toString()) : null;
    }

    public BooleanValue getAsBooleanValue() {
        Boolean valueAsBoolean = (Boolean)this.value;
        return valueAsBoolean != null ? new BooleanValue(valueAsBoolean) : null;
    }

    public DateValue getAsDateValue() {
        Date valueAsDate = (Date)this.value;
        GregorianCalendar valueAsGc = new GregorianCalendar();
        valueAsGc.setTime(valueAsDate);
        XMLGregorianCalendar xmlGc = XmlUtils.XML_TEMPORAL_DATATYPE_FACTORY.newXMLGregorianCalendar(valueAsGc);
        return valueAsDate != null ? DateValue.getInstance((XMLGregorianCalendar)xmlGc) : null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

