/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.authz;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.DecisionType;
import org.aeonbits.owner.KrauseningConfigFactory;
import org.ow2.authzforce.core.pdp.api.AttributeFqn;
import org.ow2.authzforce.core.pdp.api.AttributeFqns;
import org.ow2.authzforce.core.pdp.api.DecisionRequest;
import org.ow2.authzforce.core.pdp.api.DecisionRequestBuilder;
import org.ow2.authzforce.core.pdp.api.DecisionResult;
import org.ow2.authzforce.core.pdp.api.value.AttributeBag;
import org.ow2.authzforce.core.pdp.api.value.AttributeValue;
import org.ow2.authzforce.core.pdp.api.value.Bags;
import org.ow2.authzforce.core.pdp.api.value.Datatype;
import org.ow2.authzforce.core.pdp.api.value.StandardDatatypes;
import org.ow2.authzforce.core.pdp.api.value.StringValue;
import org.ow2.authzforce.core.pdp.impl.BasePdpEngine;
import org.ow2.authzforce.core.pdp.impl.PdpEngineConfiguration;
import org.ow2.authzforce.xacml.identifiers.XacmlAttributeCategory;
import org.ow2.authzforce.xacml.identifiers.XacmlAttributeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.authz.PolicyDecision;
import org.technologybrewery.fermenter.stout.authz.config.AuthorizationConfig;
import org.technologybrewery.fermenter.stout.exception.UnrecoverableException;

public class PolicyDecisionPoint {
    private static final Logger logger = LoggerFactory.getLogger(PolicyDecisionPoint.class);
    private static final String DECISION_MESSAGE = "Authz: {} {} to {} on {} in {}ms";
    private BasePdpEngine pdpEngine;
    private static PolicyDecisionPoint instance = new PolicyDecisionPoint();
    private final AuthorizationConfig config = (AuthorizationConfig)KrauseningConfigFactory.create(AuthorizationConfig.class, (Map[])new Map[0]);
    private Cache<String, DecisionType> decisionCache = Caffeine.newBuilder().expireAfterWrite(this.config.getDecisionCacheExpirationInMinutes(), TimeUnit.MINUTES).build();

    protected PolicyDecisionPoint() {
        try {
            String accessExternalSchemaType = this.config.getAccessExternalSchemaType();
            String pdpConfigurationLocation = this.config.getPdpConfigurationLocation();
            String pdpCatalogLocation = this.config.getPdpCatalogLocation();
            String pdpExtensionXsdLocation = this.config.getPdpExtensionXsdLocation();
            System.setProperty("javax.xml.accessExternalSchema", accessExternalSchemaType);
            PdpEngineConfiguration pdpEngineConfiguration = PdpEngineConfiguration.getInstance((String)pdpConfigurationLocation, (String)pdpCatalogLocation, (String)pdpExtensionXsdLocation);
            this.pdpEngine = new BasePdpEngine(pdpEngineConfiguration);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new UnrecoverableException("Problem creating the PDP!", (Throwable)e);
        }
    }

    public static PolicyDecisionPoint getInstance() {
        return instance;
    }

    public PolicyDecision isAuthorized(String subject, String resource, String action) {
        long start = System.currentTimeMillis();
        StringBuilder cacheKeyBuilder = new StringBuilder();
        cacheKeyBuilder.append(subject).append(':').append(resource).append(':').append(action);
        String cacheKey = cacheKeyBuilder.toString();
        DecisionType decision = (DecisionType)this.decisionCache.getIfPresent((Object)cacheKey);
        if (decision == null) {
            DecisionRequestBuilder requestBuilder = this.pdpEngine.newRequestBuilder(-1, -1);
            this.addSubjectAttribute(subject, requestBuilder);
            this.addResourceAttribute(resource, requestBuilder);
            this.addActionAttribute(action, requestBuilder);
            DecisionRequest decisionRequest = requestBuilder.build(false);
            DecisionResult result = this.pdpEngine.evaluate(decisionRequest);
            Optional causeForIndeterminate = result.getCauseForIndeterminate();
            decision = result.getDecision();
            this.decisionCache.put((Object)cacheKey, (Object)decision);
        }
        long stop = System.currentTimeMillis();
        if (!DecisionType.PERMIT.equals((Object)decision)) {
            if (logger.isWarnEnabled()) {
                logger.warn(DECISION_MESSAGE, new Object[]{decision, subject, action, resource, stop - start});
            }
        } else if (logger.isInfoEnabled()) {
            logger.warn(DECISION_MESSAGE, new Object[]{decision, subject, action, resource, stop - start});
        }
        return PolicyDecision.valueOf(decision.toString());
    }

    private void addActionAttribute(String action, DecisionRequestBuilder<?> requestBuilder) {
        AttributeFqn actionIdAttributeId = AttributeFqns.newInstance((String)XacmlAttributeCategory.XACML_3_0_ACTION.value(), Optional.empty(), (String)XacmlAttributeId.XACML_1_0_ACTION_ID.value());
        AttributeBag actionIdAttributeValues = Bags.singletonAttributeBag((Datatype)StandardDatatypes.STRING, (AttributeValue)new StringValue(action));
        requestBuilder.putNamedAttributeIfAbsent(actionIdAttributeId, actionIdAttributeValues);
    }

    private void addResourceAttribute(String resource, DecisionRequestBuilder<?> requestBuilder) {
        AttributeFqn resourceIdAttributeId = AttributeFqns.newInstance((String)XacmlAttributeCategory.XACML_3_0_RESOURCE.value(), Optional.empty(), (String)XacmlAttributeId.XACML_1_0_RESOURCE_ID.value());
        AttributeBag resourceIdAttributeValues = Bags.singletonAttributeBag((Datatype)StandardDatatypes.STRING, (AttributeValue)new StringValue(resource));
        requestBuilder.putNamedAttributeIfAbsent(resourceIdAttributeId, resourceIdAttributeValues);
    }

    private void addSubjectAttribute(String subject, DecisionRequestBuilder<?> requestBuilder) {
        AttributeFqn subjectIdAttributeId = AttributeFqns.newInstance((String)XacmlAttributeCategory.XACML_1_0_ACCESS_SUBJECT.value(), Optional.empty(), (String)XacmlAttributeId.XACML_1_0_SUBJECT_ID.value());
        AttributeBag subjectIdAttributeValues = Bags.singletonAttributeBag((Datatype)StandardDatatypes.STRING, (AttributeValue)new StringValue(subject));
        requestBuilder.putNamedAttributeIfAbsent(subjectIdAttributeId, subjectIdAttributeValues);
    }
}

