/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.authz;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeDesignatorType;
import org.aeonbits.owner.KrauseningConfigFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.ow2.authzforce.core.pdp.api.AttributeFqn;
import org.ow2.authzforce.core.pdp.api.AttributeProvider;
import org.ow2.authzforce.core.pdp.api.BaseNamedAttributeProvider;
import org.ow2.authzforce.core.pdp.api.CloseableNamedAttributeProvider;
import org.ow2.authzforce.core.pdp.api.EnvironmentProperties;
import org.ow2.authzforce.core.pdp.api.EvaluationContext;
import org.ow2.authzforce.core.pdp.api.IndeterminateEvaluationException;
import org.ow2.authzforce.core.pdp.api.value.AttributeBag;
import org.ow2.authzforce.core.pdp.api.value.AttributeValueFactoryRegistry;
import org.ow2.authzforce.core.pdp.api.value.Bags;
import org.ow2.authzforce.core.pdp.api.value.Datatype;
import org.ow2.authzforce.core.pdp.api.value.IntegerValue;
import org.ow2.authzforce.core.pdp.api.value.SimpleValue;
import org.ow2.authzforce.xacml.identifiers.XacmlAttributeId;
import org.ow2.authzforce.xacml.identifiers.XacmlStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.authz.AttributeValue;
import org.technologybrewery.fermenter.stout.authz.StoutAttributePoint;
import org.technologybrewery.fermenter.stout.authz.StoutAttributeUtils;
import org.technologybrewery.fermenter.stout.authz.attribute._2.StoutAttributeExtension;
import org.technologybrewery.fermenter.stout.authz.config.AuthorizationConfig;
import org.technologybrewery.fermenter.stout.authz.json.StoutAttribute;

public class StoutAttributeProvider
extends BaseNamedAttributeProvider {
    private static final String XML_SCHEMA_DATE = "http://www.w3.org/2001/XMLSchema#date";
    private static final String XML_SCHEMA_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static final String XML_SCHEMA_ANY_URI = "http://www.w3.org/2001/XMLSchema#anyURI";
    private static final String XML_SCHEMA_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static final String XML_SCHEMA_STRING = "http://www.w3.org/2001/XMLSchema#string";
    private static final String XML_SCHEMA_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static final TypeReference<List<StoutAttribute>> attributeListTypeReference = new TypeReference<List<StoutAttribute>>(){};
    private static final Logger logger = LoggerFactory.getLogger(StoutAttributeProvider.class);
    protected AuthorizationConfig config = (AuthorizationConfig)KrauseningConfigFactory.create(AuthorizationConfig.class, (Map[])new Map[0]);
    protected Map<String, AttributeDesignatorType> supportedDesignatorTypes = new HashMap<String, AttributeDesignatorType>();
    protected Map<Class<StoutAttributePoint>, StoutAttributePoint> pointClassToInstanceMap = new HashMap<Class<StoutAttributePoint>, StoutAttributePoint>();
    protected Map<String, StoutAttributePoint> idToAttributePointMap = new HashMap<String, StoutAttributePoint>();
    private Cache<String, Collection<AttributeValue<?>>> attributeCache;

    private StoutAttributeProvider(StoutAttributeExtension conf) {
        super(conf.getId());
        this.loadAttributeConfiguration();
    }

    public StoutAttributeProvider() {
        super(RandomStringUtils.randomAlphabetic((int)10));
        this.loadAttributeConfiguration();
    }

    public void close() throws IOException {
    }

    public Set<AttributeDesignatorType> getProvidedAttributes() {
        return Collections.unmodifiableSet(new HashSet<AttributeDesignatorType>(this.supportedDesignatorTypes.values()));
    }

    public <AV extends org.ow2.authzforce.core.pdp.api.value.AttributeValue> AttributeBag<AV> get(AttributeFqn attributeGUID, Datatype<AV> attributeDatatype, EvaluationContext context) throws IndeterminateEvaluationException {
        String id = attributeGUID.getId();
        String subject = this.findSubjectInEnvironmentContext(context);
        ArrayList attributeCollection = new ArrayList();
        Collection<AttributeValue<?>> retrievedValues = this.getStoutAttributeByIdAndSubject(id, subject);
        if (retrievedValues != null) {
            for (AttributeValue<?> retrievedValue : retrievedValues) {
                SimpleValue<?> simpleValue = this.convertRetrievedValueToXacmlFormat(attributeDatatype, id, subject, retrievedValue);
                if (simpleValue == null) continue;
                attributeCollection.add(simpleValue);
            }
        }
        AttributeBag attrVals = Bags.newAttributeBag(attributeDatatype, attributeCollection);
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved attribute '{}' for subject '{}' with the values '{}'", new Object[]{id, subject, attributeCollection});
        }
        if (attrVals == null || attrVals.getElementDatatype().equals(attributeDatatype)) {
            return attrVals;
        }
        throw new IndeterminateEvaluationException("Requested datatype (" + attributeDatatype + ") != provided by " + this + " (" + attrVals.getElementDatatype() + ")", XacmlStatusCode.MISSING_ATTRIBUTE.value());
    }

    public Collection<AttributeValue<?>> getStoutAttributeByIdAndSubject(String id, String subject) {
        StringBuilder builder = new StringBuilder();
        String cacheKey = builder.append(subject).append(':').append(id).toString();
        Collection<AttributeValue<?>> retrievedValues = (Collection<AttributeValue<?>>)this.attributeCache.getIfPresent((Object)cacheKey);
        if (retrievedValues == null) {
            StoutAttributePoint attributePoint = this.idToAttributePointMap.get(id);
            retrievedValues = attributePoint.getValueForAttribute(id, subject);
            this.attributeCache.put((Object)cacheKey, retrievedValues);
        }
        return retrievedValues;
    }

    protected <AV extends org.ow2.authzforce.core.pdp.api.value.AttributeValue> SimpleValue<?> convertRetrievedValueToXacmlFormat(Datatype<AV> attributeDatatype, String id, String subject, AttributeValue<?> retrievedValue) {
        IntegerValue simpleValue = null;
        if (retrievedValue != null) {
            switch (attributeDatatype.toString()) {
                case "http://www.w3.org/2001/XMLSchema#integer": {
                    simpleValue = retrievedValue.getAsIntegerValue();
                    break;
                }
                case "http://www.w3.org/2001/XMLSchema#string": {
                    simpleValue = retrievedValue.getAsStringValue();
                    break;
                }
                case "http://www.w3.org/2001/XMLSchema#boolean": {
                    simpleValue = retrievedValue.getAsBooleanValue();
                    break;
                }
                case "http://www.w3.org/2001/XMLSchema#anyURI": {
                    simpleValue = retrievedValue.getAsAnyUriValue();
                    break;
                }
                case "http://www.w3.org/2001/XMLSchema#double": {
                    simpleValue = retrievedValue.getAsDoubleValue();
                    break;
                }
                case "http://www.w3.org/2001/XMLSchema#date": {
                    simpleValue = retrievedValue.getAsDateValue();
                    break;
                }
                default: {
                    simpleValue = retrievedValue.getAsStringValue();
                    logger.warn("No type of '{}' was found for attribute '{}', converting to string!", attributeDatatype, (Object)id);
                }
            }
        }
        return simpleValue;
    }

    protected String findSubjectInEnvironmentContext(EvaluationContext context) {
        String subject = null;
        Iterator contextAttributeIterator = context.getNamedAttributes();
        while (contextAttributeIterator.hasNext()) {
            Map.Entry contextAttribute = (Map.Entry)contextAttributeIterator.next();
            AttributeFqn attributeFullyQualifiedName = (AttributeFqn)contextAttribute.getKey();
            if (!XacmlAttributeId.XACML_1_0_SUBJECT_ID.value().equals(attributeFullyQualifiedName.getId())) continue;
            subject = ((AttributeBag)contextAttribute.getValue()).getSingleElement().toString();
            break;
        }
        return subject;
    }

    protected void loadAttributeConfiguration() {
        String attributeLocation = this.config.getAttributeDefinitionLocation();
        ObjectMapper mapper = new ObjectMapper();
        File root = new File(attributeLocation);
        if (root.exists()) {
            String[] extensions = new String[]{"json"};
            Collection files = FileUtils.listFiles((File)root, (String[])extensions, (boolean)true);
            if (files.isEmpty()) {
                logger.warn("Your PDP is configured to use custom attributes, but the location that defines these attributes does not contain any attribute definitions! - {}", (Object)root.getAbsolutePath());
            }
            for (File attributeDefintionFile : files) {
                List<StoutAttribute> attributes = null;
                try {
                    attributes = (List<StoutAttribute>)mapper.readValue(attributeDefintionFile, attributeListTypeReference);
                    for (StoutAttribute attribute : attributes) {
                        this.addAttributeDefinition(attribute);
                    }
                }
                catch (IOException e) {
                    logger.error("Problem loading attributes in file {}!", (Object)attributeDefintionFile.getAbsolutePath(), (Object)e);
                    attributes = Collections.emptyList();
                }
                logger.info("Found {} attribute definitions in file {}", (Object)attributes.size(), (Object)attributeDefintionFile.getAbsolutePath());
            }
        } else {
            logger.warn("\n");
            logger.warn("*********************************************************************************");
            logger.warn("Your PDP is configured to use custom attributes, but the location that defines these attributes does not exist! - {}", (Object)root.getAbsolutePath());
            logger.warn("Update the your authorization.properties via Krausening to point to a valid location for attribute json files!");
            logger.warn("*********************************************************************************");
            logger.warn("\n");
        }
        this.attributeCache = Caffeine.newBuilder().expireAfterWrite(this.config.getAttributeCacheExpirationInMinutes(), TimeUnit.MINUTES).build();
    }

    protected void addAttributeDefinition(StoutAttribute attribute) {
        String id = attribute.getId();
        AttributeDesignatorType designatorType = StoutAttributeUtils.translateAttributeToXacmlFormat(attribute);
        AttributeDesignatorType existingDesignatorType = this.supportedDesignatorTypes.put(id, designatorType);
        StoutAttributePoint attributePoint = this.findAttributePointImplementation(attribute);
        this.idToAttributePointMap.put(id, attributePoint);
        logger.info("Translated Stout attribute definition '{}' into the fully qualified \n\t{}", (Object)id, (Object)designatorType);
        if (existingDesignatorType != null) {
            logger.warn("Multiple attributes named '{}' exist!  The last one in read will be used {}", (Object)id, (Object)designatorType);
        }
    }

    protected StoutAttributePoint findAttributePointImplementation(StoutAttribute attribute) {
        StoutAttributePoint attributePoint = null;
        String attributePointClassName = null;
        try {
            attributePointClassName = attribute.getAttributePointClass();
            if (StringUtils.isBlank((CharSequence)attributePointClassName)) {
                logger.error("No attribute point specified for attribute '{}'!", (Object)attribute.getId());
            } else {
                Class<?> attributePointClass = Class.forName(attributePointClassName);
                attributePoint = this.pointClassToInstanceMap.get(attributePointClass);
                if (attributePoint == null) {
                    attributePoint = (StoutAttributePoint)attributePointClass.newInstance();
                    this.pointClassToInstanceMap.put(attributePointClass, attributePoint);
                    logger.debug("Instantiated AttributePoint '{}'", (Object)attributePointClass.getName());
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not find attribute point '{}' in classpath!", (Object)attributePointClassName);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Could not instantiate attribute point '" + attributePointClassName + "'!", (Throwable)e);
        }
        return attributePoint;
    }

    public static class Factory
    extends CloseableNamedAttributeProvider.FactoryBuilder<StoutAttributeExtension> {
        public Class<StoutAttributeExtension> getJaxbClass() {
            return StoutAttributeExtension.class;
        }

        public CloseableNamedAttributeProvider.DependencyAwareFactory getInstance(final StoutAttributeExtension conf, EnvironmentProperties envProperties) {
            return new CloseableNamedAttributeProvider.DependencyAwareFactory(){

                public Set<AttributeDesignatorType> getDependencies() {
                    return null;
                }

                public CloseableNamedAttributeProvider getInstance(AttributeValueFactoryRegistry attrDatatypeFactory, AttributeProvider depAttrProvider) {
                    return new StoutAttributeProvider(conf);
                }
            };
        }
    }
}

