/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.authz.json;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.aeonbits.owner.KrauseningConfigFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.authz.AttributeValue;
import org.technologybrewery.fermenter.stout.authz.PolicyDecision;
import org.technologybrewery.fermenter.stout.authz.PolicyDecisionPoint;
import org.technologybrewery.fermenter.stout.authz.StoutAttributeProvider;
import org.technologybrewery.fermenter.stout.authz.config.AuthorizationConfig;
import org.technologybrewery.fermenter.stout.authz.json.AbstractAuthorizationRequest;
import org.technologybrewery.fermenter.stout.authz.json.AttributeRequest;
import org.technologybrewery.fermenter.stout.authz.json.PolicyRequest;

public final class JsonWebTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonWebTokenUtil.class);
    private static AuthorizationConfig config = (AuthorizationConfig)KrauseningConfigFactory.create(AuthorizationConfig.class, (Map[])new Map[0]);
    private static String keyAlias = config.getKeyAlias();
    private static String keyStoreLocation = config.getKeyStoreLocation();
    private static String keyStorePasswordLocation = config.getKeyStorePasswordLocation();
    private static String keyStoreType = config.getKeyStoreType();
    private static PolicyDecisionPoint pdp = PolicyDecisionPoint.getInstance();
    private static StoutAttributeProvider attributeProvider = new StoutAttributeProvider();
    private static Key signingKey;
    private static Certificate certificate;

    private JsonWebTokenUtil() {
    }

    public static String createToken(String subject, String audience, Collection<? extends AbstractAuthorizationRequest> ruleClaims) {
        JwtBuilder builder = Jwts.builder();
        builder.setId(UUID.randomUUID().toString());
        builder.setSubject(subject);
        builder.setAudience(audience);
        Date currentTime = new Date();
        builder.setNotBefore(new Date(currentTime.getTime() - JsonWebTokenUtil.getSkewInMillis()));
        builder.setIssuedAt(currentTime);
        builder.setExpiration(new Date(currentTime.getTime() + JsonWebTokenUtil.getExpirationInMillis() + JsonWebTokenUtil.getSkewInMillis()));
        if (ruleClaims != null) {
            for (AbstractAuthorizationRequest abstractAuthorizationRequest : ruleClaims) {
                if (AbstractAuthorizationRequest.ClaimType.POLICY.equals((Object)abstractAuthorizationRequest.getClaimType())) {
                    PolicyRequest policyClaim = (PolicyRequest)abstractAuthorizationRequest;
                    PolicyDecision decision = pdp.isAuthorized(subject, policyClaim.getResource(), policyClaim.getAction());
                    builder.claim(policyClaim.toString(), (Object)decision.toString());
                    continue;
                }
                AttributeRequest attributeClaim = (AttributeRequest)abstractAuthorizationRequest;
                Collection<AttributeValue<?>> foundAttributes = attributeProvider.getStoutAttributeByIdAndSubject(attributeClaim.getRequestedAttributeId(), subject);
                String attributeValue = null;
                if (foundAttributes != null) {
                    attributeValue = foundAttributes.stream().map(AttributeValue::getValueAsString).collect(Collectors.joining(","));
                }
                builder.claim(attributeClaim.getRequestedAttributeId(), attributeValue);
            }
        }
        try {
            signingKey = JsonWebTokenUtil.getSigningKey();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unable to retrieve private key", e);
        }
        builder.setIssuer(JsonWebTokenUtil.getIssuer());
        builder.signWith(signingKey);
        return builder.compact();
    }

    public static Jws<Claims> parseLocalToken(String token) {
        JwtParser parser = Jwts.parser();
        parser.setSigningKey(signingKey);
        Jws jwt = parser.parseClaimsJws(token);
        if (logger.isDebugEnabled()) {
            logger.debug("Parsed the following JWT: {}", (Object)jwt);
        }
        return jwt;
    }

    private static long getSkewInMillis() {
        return config.getTokenSkewInSeconds() * 1000L;
    }

    private static long getExpirationInMillis() {
        return config.getTokenExpirationInSeconds() * 1000L;
    }

    private static String getIssuer() {
        String issuer = null;
        issuer = config.getTokenIssuer();
        if (StringUtils.isBlank((CharSequence)issuer)) {
            if (certificate != null) {
                X509Certificate cert = (X509Certificate)certificate;
                issuer = cert.getIssuerDN().getName();
            } else {
                issuer = "unspecified";
                logger.warn("No signing certificate found, defaulting to {}", (Object)issuer);
            }
        }
        return issuer;
    }

    private static Key getSigningKey() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        Key privateKey;
        String storeLocation = System.getProperty(keyStoreLocation);
        String ksPw = System.getProperty(keyStorePasswordLocation);
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        if (storeLocation != null && ksPw != null) {
            ks.load(new FileInputStream(storeLocation), ksPw.toCharArray());
            certificate = ks.getCertificate(keyAlias);
            privateKey = ks.getKey(keyAlias, ksPw.toCharArray());
            logger.debug("Successfully retrieved key and certificate");
        } else {
            privateKey = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
        }
        return privateKey;
    }
}

