package org.technologybrewery.fermenter.stout.messages.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.stout.messages.Message;
import org.technologybrewery.fermenter.stout.messages.Severity;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

/**
 * De-serializes the given JSON content, which is expected to be generated by
 * {@link MessageSerializer}, into it's corresponding {@link Message} object
 * representation.
 */
public class MessageDeserializer extends JsonDeserializer<Message> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Message deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
		AnonymousMetaMessage metaMessage = new AnonymousMetaMessage();
		Severity severity = null;
		Map<String, Object> inserts = new HashMap<>();

		while (jp.nextToken() != JsonToken.END_OBJECT) {
			String fieldName = jp.getCurrentName();
			if ("name".equals(fieldName)) {
				metaMessage.setName(jp.nextTextValue());
			} else if ("rawText".equals(fieldName)) {
				metaMessage.setText(jp.nextTextValue());
			} else if ("severity".equals(fieldName)) {
				String severityStr = jp.nextTextValue();
				if (StringUtils.isNotEmpty(severityStr)) {
					severity = Severity.valueOf(severityStr);
				}
			} else if ("inserts".equals(fieldName)) {
				jp.nextToken();
				while (jp.nextToken() != JsonToken.END_ARRAY) {
					while (jp.nextToken() != JsonToken.END_OBJECT) {
						String insertName = jp.getCurrentName();
						String insertValue = jp.nextTextValue();
						inserts.put(insertName, insertValue);
					}
				}
			}
		}

		return new Message(metaMessage, severity, inserts);

	}

}
