/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.client.service;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.jta.JtaTransactionManager;

public abstract class AbstractMaintenanceServiceDelegate
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMaintenanceServiceDelegate.class);
    private TransactionManager transactionManager;

    public void setApplicationContext(ApplicationContext applicationContext) {
        try {
            JtaTransactionManager springTxManager = (JtaTransactionManager)applicationContext.getBean(JtaTransactionManager.class);
            this.transactionManager = springTxManager.getTransactionManager();
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.info("Not in a transactional context, level one rest client caching disabled.");
        }
    }

    protected boolean checkLevelOneCache() {
        boolean useLevelOneCache = false;
        try {
            useLevelOneCache = this.transactionManager != null && this.transactionManager.getTransaction() != null;
        }
        catch (SystemException e) {
            logger.error("TransactionManager is present but fails to return current transaction!", (Throwable)e);
        }
        return useLevelOneCache;
    }

    public abstract void flushInsertsAndUpdates();

    public abstract void flushDeletes();
}

