/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.client.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LevelOneCache<K, T> {
    private Map<K, T> lookupMap = new HashMap<K, T>();
    private Set<T> pendingInserts = new HashSet<T>();
    private Map<K, T> pendingUpdates = new HashMap<K, T>();
    private Set<K> pendingDeletes = new HashSet<K>();

    public void create(T instance) {
        this.pendingInserts.add(instance);
    }

    public void createAndCache(K primaryKey, T instance) {
        this.pendingInserts.add(instance);
        this.lookupMap.put(primaryKey, instance);
    }

    public T retrieve(K id) {
        return this.lookupMap.get(id);
    }

    public Collection<T> getPendingInserts() {
        return this.pendingInserts;
    }

    public void update(K primaryKey, T entity) {
        this.pendingUpdates.put(primaryKey, entity);
        this.lookupMap.put(primaryKey, entity);
    }

    public void cache(K primaryKey, T entity) {
        this.lookupMap.put(primaryKey, entity);
    }

    public Collection<T> getPendingUpdates() {
        return this.pendingUpdates.values();
    }

    public void delete(K primaryKey) {
        this.pendingDeletes.add(primaryKey);
        this.lookupMap.remove(primaryKey);
    }

    public void delete(Collection<K> primaryKeys) {
        this.pendingDeletes.addAll(primaryKeys);
        for (K primaryKey : primaryKeys) {
            this.lookupMap.remove(primaryKey);
        }
    }

    public Collection<K> getPendingDeletes() {
        return this.pendingDeletes;
    }

    public void clearPendingInsertsAndUpdates() {
        this.pendingInserts.clear();
        this.pendingUpdates.clear();
    }

    public void clearPendingDeletes() {
        this.pendingInserts.clear();
        this.pendingUpdates.clear();
        this.pendingDeletes.clear();
    }

    public void clearPendingActions() {
        this.clearPendingInsertsAndUpdates();
        this.clearPendingDeletes();
    }
}

