/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.client.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.technologybrewery.fermenter.stout.client.service.LevelOneCache;
import org.technologybrewery.fermenter.stout.exception.UnrecoverableException;
import org.technologybrewery.fermenter.stout.util.SpringAutowiringUtil;

public class LevelOneCacheManager<K, T> {
    private Map<Transaction, LevelOneCache<K, T>> levelOneCacheByTransaction = new ConcurrentHashMap<Transaction, LevelOneCache<K, T>>();
    @Inject
    private JtaTransactionManager springTxManager;

    public LevelOneCacheManager() {
        SpringAutowiringUtil.autowireBizObj((Object)this);
    }

    public LevelOneCache<K, T> getCacheForCurrentTransaction() {
        Transaction currentTransaction = this.getCurrentTransaction();
        LevelOneCache<K, T> cacheForCurrentTransaction = this.levelOneCacheByTransaction.get(currentTransaction);
        if (cacheForCurrentTransaction == null) {
            cacheForCurrentTransaction = new LevelOneCache();
            this.levelOneCacheByTransaction.put(currentTransaction, cacheForCurrentTransaction);
        }
        return cacheForCurrentTransaction;
    }

    private Transaction getCurrentTransaction() {
        Transaction currentTransaction = null;
        try {
            if (this.springTxManager == null) {
                SpringAutowiringUtil.autowireBizObj((Object)this);
            }
            TransactionManager transactionManager = this.springTxManager.getTransactionManager();
            currentTransaction = transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new UnrecoverableException("Could not get transaction for current thread!", (Throwable)e);
        }
        return currentTransaction;
    }

    public void removeTransaction() {
        Transaction currentTransaction = this.getCurrentTransaction();
        this.levelOneCacheByTransaction.remove(currentTransaction);
    }
}

