/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.client.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.technologybrewery.fermenter.stout.client.service.LocalOptimizationUtil;
import org.technologybrewery.fermenter.stout.exception.UnrecoverableException;
import org.technologybrewery.fermenter.stout.util.SpringApplicationContextHolder;

public class LocalOptimizationServiceWrapper {
    private static final Logger logger = LoggerFactory.getLogger(LocalOptimizationServiceWrapper.class);
    private Class<?> serviceClass;
    private Map<String, Method> methodsByName = new ConcurrentHashMap<String, Method>();

    public LocalOptimizationServiceWrapper(String serviceClassName) {
        if (serviceClassName == null) {
            throw new UnrecoverableException("Cannot optimize a null class!");
        }
        this.serviceClass = LocalOptimizationUtil.lookupClassByName(serviceClassName);
        if (this.serviceClass == null) {
            throw new UnrecoverableException("Clazz " + serviceClassName + "could not be found in classpath!");
        }
        this.indexClassForLocalOptimization();
    }

    private void indexClassForLocalOptimization() {
        Method[] methods;
        for (Method method : methods = this.serviceClass.getMethods()) {
            this.methodsByName.put(method.getName(), method);
        }
    }

    public Object invokeLocalService(String methodName, Object[] params) {
        Object response = null;
        ApplicationContext applicationContext = SpringApplicationContextHolder.getContext();
        String[] beans = applicationContext.getBeanNamesForType(this.serviceClass);
        if (beans != null && beans.length == 1) {
            Object localService = applicationContext.getBean(beans[0]);
            Method method = this.methodsByName.get(methodName);
            try {
                response = method.invoke(localService, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                String message = String.format("Could not invoke: %s.%s with the parameters types %s", this.serviceClass.getName(), methodName, method.getParameterTypes());
                throw new UnrecoverableException(message, (Throwable)e);
            }
        }
        return response;
    }

    public Object invokeLocalService(String methodName, Class<?>[] parameterTypes, Object[] params) {
        Object response = null;
        ApplicationContext applicationContext = SpringApplicationContextHolder.getContext();
        String[] beans = applicationContext.getBeanNamesForType(this.serviceClass);
        if (beans != null && beans.length == 1) {
            Object localService = applicationContext.getBean(beans[0]);
            try {
                Method method = this.serviceClass.getMethod(methodName, parameterTypes);
                response = method.invoke(localService, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error("Could not invoke: {}.{} with the parameters types {}", new Object[]{this.serviceClass.getName(), methodName, parameterTypes});
                throw new UnrecoverableException("Could not invoke expected method (" + methodName + ")!", (Throwable)e);
            }
        }
        return response;
    }
}

