/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.client.service;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.gc.iotools.stream.os.OutputStreamToInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.technologybrewery.fermenter.stout.exception.UnrecoverableException;
import org.technologybrewery.fermenter.stout.messages.Messages;
import org.technologybrewery.fermenter.stout.page.PageWrapper;
import org.technologybrewery.fermenter.stout.page.json.FindByExampleCriteria;
import org.technologybrewery.fermenter.stout.service.ValueServiceResponse;
import org.technologybrewery.fermenter.stout.transfer.TransferObject;
import org.technologybrewery.fermenter.stout.util.SpringApplicationContextHolder;

public final class LocalOptimizationUtil {
    private static final Logger logger = LoggerFactory.getLogger(LocalOptimizationUtil.class);
    private static LocalOptimizationUtil instance = new LocalOptimizationUtil();
    private static ObjectMapper objectMapper;

    private LocalOptimizationUtil() {
    }

    public static boolean isLocalServicePresent(String serviceClassName) {
        boolean containsServiceBean = false;
        Class<?> serviceClass = LocalOptimizationUtil.lookupClassByName(serviceClassName);
        if (serviceClass != null) {
            ApplicationContext applicationContext = SpringApplicationContextHolder.getContext();
            if (applicationContext != null) {
                String[] beans = applicationContext.getBeanNamesForType(serviceClass);
                boolean bl = containsServiceBean = beans != null && beans.length == 1;
            }
            if (!containsServiceBean) {
                String message = "{} exists in the classpath - but not as a Spring bean.  Resolution options:\n\t * Remove the jar containing this class from your classpath to use Stout remoting\n\t * Register the beans for this service so local service optimization can occur\n\nRemote calls will continue to happen over HTTP/S until this is resolved!";
                logger.warn(message, (Object)serviceClassName);
            }
        }
        return containsServiceBean;
    }

    public static Object convertToBusinessObjectViaJson(Collection<? extends TransferObject> transferObjectList, ObjectMapper objectMapper) {
        ArrayList<Object> resultList = transferObjectList != null ? new ArrayList<Object>(transferObjectList.size()) : Collections.emptyList();
        for (TransferObject transferObject : transferObjectList) {
            Object businessObject = LocalOptimizationUtil.convertToBusinessObjectViaJson(transferObject, objectMapper);
            resultList.add(businessObject);
        }
        return resultList;
    }

    public static Object convertToBusinessObjectViaJson(FindByExampleCriteria<? extends TransferObject> criteria, ObjectMapper objectMapper) {
        FindByExampleCriteria<Object> businessObjectCriteria = new FindByExampleCriteria<Object>();
        TransferObject probe = criteria.getProbe();
        if (probe != null) {
            Object businessObjectProbe = LocalOptimizationUtil.convertToBusinessObjectViaJson(probe, objectMapper);
            businessObjectCriteria.setProbe(businessObjectProbe);
        }
        businessObjectCriteria.setContainsMatch(criteria.getContainsMatch());
        businessObjectCriteria.setCount(criteria.getCount());
        businessObjectCriteria.setSortWrapper(criteria.getSortWrapper());
        businessObjectCriteria.setStartPage(criteria.getStartPage());
        return businessObjectCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertToBusinessObjectViaJson(TransferObject transferObject, ObjectMapper objectMapper) {
        Object result = null;
        try {
            LocalOptimizationUtil localOptimizationUtil = instance;
            Objects.requireNonNull(localOptimizationUtil);
            TransferObjectJsonOutputStream streamOutputToInput = localOptimizationUtil.new TransferObjectJsonOutputStream(objectMapper, transferObject.getClass());
            try {
                objectMapper.writeValue((OutputStream)((Object)streamOutputToInput), (Object)transferObject);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)((Object)streamOutputToInput));
                result = streamOutputToInput.getResult();
            }
        }
        catch (Exception e) {
            throw new UnrecoverableException("Could not marshall from " + transferObject.getClass() + " to the BusinessObject equivilant!", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertResponseToTransferObjectViaJson(Object input, Class<?> transferObjectTargetClass, ObjectMapper objectMapper) {
        ValueServiceResponse result = null;
        ValueServiceResponse businessObjectServiceResponse = (ValueServiceResponse)input;
        try {
            LocalOptimizationUtil localOptimizationUtil = instance;
            Objects.requireNonNull(localOptimizationUtil);
            BusinessObjectJsonOutputStream streamOutputToInput = localOptimizationUtil.new BusinessObjectJsonOutputStream(objectMapper, transferObjectTargetClass);
            try {
                objectMapper.writeValue((OutputStream)((Object)streamOutputToInput), businessObjectServiceResponse.getValue());
            }
            finally {
                IOUtils.closeQuietly((OutputStream)((Object)streamOutputToInput));
                result = (ValueServiceResponse)streamOutputToInput.getResult();
                Messages originalMessages = businessObjectServiceResponse.getMessages();
                result.getMessages().addMessages(originalMessages);
            }
        }
        catch (Exception e) {
            Object businessObject = businessObjectServiceResponse != null ? businessObjectServiceResponse.getValue() : null;
            String businessObjectClass = businessObject != null ? businessObject.getClass().getName() : null;
            throw new UnrecoverableException("Could not marshall from " + businessObjectClass + " to " + transferObjectTargetClass + " equivilant!", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertResponseToTransferObjectListViaJson(Object input, Class<?> transferObjectTargetClass, ObjectMapper objectMapper) {
        ValueServiceResponse typedInput = (ValueServiceResponse)input;
        Messages originalMessages = typedInput.getMessages();
        ValueServiceResponse result = new ValueServiceResponse();
        LocalOptimizationUtil localOptimizationUtil = instance;
        Objects.requireNonNull(localOptimizationUtil);
        BusinessObjectCollectionJsonOutputStream streamOutputToInput = localOptimizationUtil.new BusinessObjectCollectionJsonOutputStream(objectMapper, transferObjectTargetClass);
        try {
            try {
                objectMapper.writeValue((OutputStream)((Object)streamOutputToInput), typedInput.getValue());
            }
            finally {
                IOUtils.closeQuietly((OutputStream)((Object)streamOutputToInput));
                Collection transferObjects = (Collection)streamOutputToInput.getResult();
                result.setValue((Object)transferObjects);
                result.getMessages().addMessages(originalMessages);
            }
        }
        catch (Exception e) {
            throw new UnrecoverableException("Could not convert list of BusinessObjects to a list of TransferObjects!", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertResponseToTransferObjectPageWrapperViaJson(Object input, Class<?> transferObjectTargetClass, ObjectMapper objectMapper) {
        ValueServiceResponse typedInput = (ValueServiceResponse)input;
        PageWrapper inboundWrapper = (PageWrapper)typedInput.getValue();
        ValueServiceResponse result = new ValueServiceResponse();
        LocalOptimizationUtil localOptimizationUtil = instance;
        Objects.requireNonNull(localOptimizationUtil);
        BusinessObjectCollectionJsonOutputStream streamOutputToInput = localOptimizationUtil.new BusinessObjectCollectionJsonOutputStream(objectMapper, transferObjectTargetClass);
        try {
            try {
                objectMapper.writeValue((OutputStream)((Object)streamOutputToInput), inboundWrapper.getContent());
            }
            finally {
                IOUtils.closeQuietly((OutputStream)((Object)streamOutputToInput));
                List transferObjects = (List)streamOutputToInput.getResult();
                PageWrapper pageWrapper = new PageWrapper();
                pageWrapper.setContent(transferObjects);
                pageWrapper.setFirst(inboundWrapper.isFirst());
                pageWrapper.setLast(inboundWrapper.isLast());
                pageWrapper.setItemsPerPage(inboundWrapper.getItemsPerPage());
                pageWrapper.setNumberOfElements(inboundWrapper.getNumberOfElements());
                pageWrapper.setStartPage(inboundWrapper.getStartPage());
                pageWrapper.setTotalPages(inboundWrapper.getTotalPages());
                pageWrapper.setTotalResults(inboundWrapper.getTotalResults());
                result.setValue(pageWrapper);
            }
        }
        catch (Exception e) {
            throw new UnrecoverableException("Could not convert list of BusinessObjects to a list of TransferObjects!", (Throwable)e);
        }
        return result;
    }

    public static Class<?> lookupBusinessObjectClassByTransferObject(Class<? extends TransferObject> transferObjectClass) {
        String className = transferObjectClass.getName();
        String boVarient = LocalOptimizationUtil.replaceLast(".transfer.", ".bizobj.", className) + "BO";
        return LocalOptimizationUtil.lookupClassByName(boVarient);
    }

    private static String replaceLast(String target, String replace, String original) {
        int lastIndex = original.lastIndexOf(target);
        if (lastIndex == -1) {
            return original;
        }
        String beginString = original.substring(0, lastIndex);
        String endString = original.substring(lastIndex + target.length());
        return beginString + replace + endString;
    }

    public static Class<?> lookupClassByName(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static ObjectMapper getObjectMapper(String objectMapperManagerClassName) {
        if (objectMapper == null) {
            Class<?> objectMapperManagerClass = LocalOptimizationUtil.lookupClassByName(objectMapperManagerClassName);
            if (objectMapperManagerClass == null) {
                throw new UnrecoverableException("Could not find Object Mapper Manager class " + objectMapperManagerClassName);
            }
            try {
                Method method = objectMapperManagerClass.getMethod("getObjectMapper", new Class[0]);
                objectMapper = (ObjectMapper)method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new UnrecoverableException("Could not access " + objectMapperManagerClassName, (Throwable)e);
            }
        }
        return objectMapper;
    }

    public class BusinessObjectCollectionJsonOutputStream
    extends OutputStreamToInputStream<List<TransferObject>> {
        private ObjectMapper objectMapper;
        private Class<?> transferObjectClass;

        public BusinessObjectCollectionJsonOutputStream(ObjectMapper objectMapper, Class<?> transferObjectClass) {
            this.objectMapper = objectMapper;
            this.transferObjectClass = transferObjectClass;
        }

        protected List<TransferObject> doRead(InputStream istream) throws Exception {
            CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, this.transferObjectClass);
            return (List)this.objectMapper.readValue(istream, (JavaType)type);
        }
    }

    public class BusinessObjectJsonOutputStream
    extends OutputStreamToInputStream<ValueServiceResponse<TransferObject>> {
        private ObjectMapper objectMapper;
        private Class<?> transferObjectClass;

        public BusinessObjectJsonOutputStream(ObjectMapper objectMapper, Class<?> transferObjectClass) {
            this.objectMapper = objectMapper;
            this.transferObjectClass = transferObjectClass;
        }

        protected ValueServiceResponse<TransferObject> doRead(InputStream istream) throws Exception {
            TransferObject transferObject = (TransferObject)this.objectMapper.readValue(istream, this.transferObjectClass);
            return new ValueServiceResponse((Object)transferObject);
        }
    }

    public class TransferObjectJsonOutputStream
    extends OutputStreamToInputStream<Object> {
        private ObjectMapper objectMapper;
        private Class<? extends TransferObject> transferObjectClass;

        public TransferObjectJsonOutputStream(ObjectMapper objectMapper, Class<? extends TransferObject> transferObjectClass) {
            this.objectMapper = objectMapper;
            this.transferObjectClass = transferObjectClass;
        }

        protected Object doRead(InputStream istream) throws Exception {
            Class<?> targetClass = LocalOptimizationUtil.lookupBusinessObjectClassByTransferObject(this.transferObjectClass);
            if (targetClass == null) {
                throw new UnrecoverableException("Can not find TransferObejct class to map to: " + this.transferObjectClass);
            }
            return this.objectMapper.readValue(istream, targetClass);
        }
    }
}

