/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.messages.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.stout.messages.Message;
import org.technologybrewery.fermenter.stout.messages.MetaMessage;
import org.technologybrewery.fermenter.stout.messages.Severity;
import org.technologybrewery.fermenter.stout.messages.json.AnonymousMetaMessage;

public class MessageDeserializer
extends JsonDeserializer<Message> {
    public Message deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        AnonymousMetaMessage metaMessage = new AnonymousMetaMessage();
        Severity severity = null;
        HashMap<String, String> inserts = new HashMap<String, String>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            if ("name".equals(fieldName)) {
                metaMessage.setName(jp.nextTextValue());
                continue;
            }
            if ("rawText".equals(fieldName)) {
                metaMessage.setText(jp.nextTextValue());
                continue;
            }
            if ("severity".equals(fieldName)) {
                String severityStr = jp.nextTextValue();
                if (!StringUtils.isNotEmpty((CharSequence)severityStr)) continue;
                severity = Severity.valueOf((String)severityStr);
                continue;
            }
            if (!"inserts".equals(fieldName)) continue;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String insertName = jp.getCurrentName();
                    String insertValue = jp.nextTextValue();
                    inserts.put(insertName, insertValue);
                }
            }
        }
        return new Message((MetaMessage)metaMessage, severity, inserts);
    }
}

