/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.messages.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.technologybrewery.fermenter.stout.messages.Message;
import org.technologybrewery.fermenter.stout.messages.MetaMessage;

public class MessageSerializer
extends JsonSerializer<Message> {
    public Class<Message> handledType() {
        return Message.class;
    }

    public void serialize(Message message, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        MetaMessage metaMessage = message.getMetaMessage();
        jgen.writeObjectField("name", (Object)metaMessage.toString());
        jgen.writeStringField("severity", message.getSeverity() != null ? message.getSeverity().toString() : null);
        jgen.writeArrayFieldStart("inserts");
        Collection inserts = message.getAllInserts();
        for (Map.Entry insert : inserts) {
            jgen.writeStartObject();
            String name = (String)insert.getKey();
            String value = (String)insert.getValue();
            jgen.writeStringField(name, value);
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
        jgen.writeObjectField("rawText", (Object)metaMessage.getText());
        jgen.writeStringField("displayText", message.getDisplayText());
        jgen.writeEndObject();
    }
}

