/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.util;

import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.technologybrewery.fermenter.stout.service.ServiceResponse;
import org.technologybrewery.fermenter.stout.service.ValueServiceResponse;
import org.technologybrewery.fermenter.stout.service.VoidServiceResponse;
import org.technologybrewery.fermenter.stout.util.ObjectMapperManager;

public class FeignErrorTranslator
implements ErrorDecoder {
    private final ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();

    public Exception decode(String methodKey, Response response) {
        if (response.status() > 400 && response.status() <= 499) {
            throw new WebApplicationException(response.toString());
        }
        if (response.status() == 400) {
            ServiceResponse errorResponse = this.getResponseBody(response);
            if (errorResponse != null) {
                javax.ws.rs.core.Response statusResponse = javax.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
                throw new WebApplicationException(statusResponse);
            }
            throw new WebApplicationException(response.toString());
        }
        return this.defaultErrorDecoder.decode(methodKey, response);
    }

    private ServiceResponse getResponseBody(Response response) {
        ServiceResponse result = null;
        try {
            String errorJson = ((Stream)new BufferedReader(new InputStreamReader(response.body().asInputStream())).lines().parallel()).collect(Collectors.joining("\n"));
            try {
                result = (ServiceResponse)ObjectMapperManager.getObjectMapper().readValue(errorJson, VoidServiceResponse.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (result == null) {
                result = (ServiceResponse)ObjectMapperManager.getObjectMapper().readValue(errorJson, ValueServiceResponse.class);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

