/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.util;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.technologybrewery.fermenter.stout.messages.Message;
import org.technologybrewery.fermenter.stout.messages.Messages;
import org.technologybrewery.fermenter.stout.messages.json.MessageDeserializer;
import org.technologybrewery.fermenter.stout.messages.json.MessageSerializer;
import org.technologybrewery.fermenter.stout.messages.json.MessagesMixIn;
import org.technologybrewery.fermenter.stout.util.TrimmingStringDeserializer;

public final class ObjectMapperManager {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private ObjectMapperManager() {
    }

    private static void configureObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(Messages.class, MessagesMixIn.class);
        module.addSerializer(Message.class, (JsonSerializer)new MessageSerializer());
        module.addDeserializer(Message.class, (JsonDeserializer)new MessageDeserializer());
        module.addDeserializer(String.class, (JsonDeserializer)new TrimmingStringDeserializer(String.class));
        objectMapper.registerModule((Module)module);
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    static {
        ObjectMapperManager.configureObjectMapper();
    }
}

