/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.bizobj;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.technologybrewery.fermenter.stout.bizobj.BaseSpringBO;
import org.technologybrewery.fermenter.stout.bizobj.PersistentBusinessObject;
import org.technologybrewery.fermenter.stout.messages.Message;
import org.technologybrewery.fermenter.stout.messages.MessageManager;

public abstract class BasePersistentSpringBO<PK extends Serializable, BO, JPA extends JpaRepository<BO, PK>>
extends BaseSpringBO<BO>
implements PersistentBusinessObject<PK, BO> {
    protected final UUID internalTransientID = UUID.randomUUID();

    public final BO save() {
        this.setDefaults();
        this.preValidate();
        this.validate();
        if (!MessageManager.hasErrorMessages()) {
            this.postValidate();
            Object persistedBizObj = this.getRepository().save((Object)this);
            this.postSave();
            return (BO)persistedBizObj;
        }
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Attempt to save BO of type [{}] with PK = [{}] was ignored due to collected errors", this.getClass(), (Object)this.getKey());
        }
        if (this.getLogger().isInfoEnabled()) {
            Collection messages = MessageManager.getMessages().getErrors();
            for (Message message : messages) {
                String displayText = message.getDisplayText();
                this.getLogger().info("Encountered the following error when trying to save persistent object: {}\n\t{}", (Object)this, (Object)displayText);
            }
        }
        return (BO)this;
    }

    protected final void setDefaults() {
        this.defaultFieldValues();
        this.defaultComplexValues();
    }

    protected void defaultFieldValues() {
    }

    protected void defaultComplexValues() {
    }

    public void delete() {
        this.getRepository().delete((Object)this);
    }

    protected abstract JPA getRepository();

    protected void postSave() {
    }

    public boolean equals(Object o) {
        boolean areEqual = false;
        try {
            Serializable thatPk;
            BasePersistentSpringBO thatBizObj = (BasePersistentSpringBO)o;
            Serializable thisPk = this.getKey();
            Serializable serializable = thatPk = thatBizObj != null ? thatBizObj.getKey() : null;
            if (thatBizObj != null && thisPk == null && thatPk == null) {
                return this.internalTransientID == thatBizObj.internalTransientID;
            }
            if (thisPk == thatPk || thisPk.equals(thatPk)) {
                areEqual = true;
            }
        }
        catch (ClassCastException ex) {
            areEqual = false;
        }
        return areEqual;
    }

    public int hashCode() {
        return this.getKey() == null ? this.internalTransientID.hashCode() : this.getKey().hashCode();
    }
}

