/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.bizobj;

import java.util.Set;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.technologybrewery.fermenter.stout.bizobj.BusinessObject;
import org.technologybrewery.fermenter.stout.messages.CoreMessages;
import org.technologybrewery.fermenter.stout.messages.FieldValidationMessages;
import org.technologybrewery.fermenter.stout.messages.Message;
import org.technologybrewery.fermenter.stout.messages.MessageManager;
import org.technologybrewery.fermenter.stout.messages.MetaMessage;
import org.technologybrewery.fermenter.stout.messages.Severity;

public abstract class BaseSpringBO<BO>
implements BusinessObject<BO> {
    @Inject
    private Validator validator;

    public void validate() {
        this.validateFields();
        this.validateReferences();
        this.validateRelations();
        if (!MessageManager.hasErrorMessages()) {
            this.complexValidation();
            this.complexValidationOnRelations();
        }
    }

    protected void preValidate() {
    }

    protected void postValidate() {
    }

    protected abstract Logger getLogger();

    public void validateFields() {
        Set violations = this.getValidator().validate((Object)this, new Class[0]);
        for (ConstraintViolation violation : violations) {
            this.addConstraintViolationToMsgMgr(violation);
        }
    }

    protected void addConstraintViolationToMsgMgr(ConstraintViolation<BO> violation) {
        String invalidPropertyName = violation.getPropertyPath().toString();
        Message message = new Message((MetaMessage)FieldValidationMessages.INVALID_FIELD, Severity.ERROR);
        message.addInsert("fieldName", (Object)invalidPropertyName);
        message.addInsert("constraintViolation", (Object)violation.getMessage());
        MessageManager.addMessage((Message)message);
    }

    protected void checkIfReferenceExists(String referenceName, Object reference) {
        if (reference == null) {
            Message message = new Message((MetaMessage)CoreMessages.INVALID_REFERENCE, Severity.ERROR);
            message.addInsert("referenceName", (Object)referenceName);
            MessageManager.addMessage((Message)message);
        }
    }

    protected abstract void validateReferences();

    protected abstract void validateRelations();

    protected abstract void complexValidation();

    protected abstract void complexValidationOnRelations();

    protected Validator getValidator() {
        return this.validator;
    }
}

