/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.messages;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.messages.MessageManager;
import org.technologybrewery.fermenter.stout.messages.Messages;

public abstract class AbstractMessageManagerAwareProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageManagerAwareProcessor.class);

    protected final void initMsgMgr(Messages messages) {
        if (messages != null) {
            MessageManager.initialize((Messages)messages);
        }
    }

    protected final void migrateToOverallMessagesAndClear(Messages overallMessages) {
        Messages messages = MessageManager.getMessages();
        String messageSummary = "Encountered " + messages.getErrorCount() + " error and " + messages.getInfoCount() + " informational messages!";
        if (messages.hasErrors()) {
            logger.error(messageSummary);
        } else {
            logger.info(messageSummary);
        }
        overallMessages.addMessages(messages);
        MessageManager.cleanup();
    }
}

