/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.messages;

import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.NotAuthorizedException;
import org.aeonbits.owner.KrauseningConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.authn.IdentityManager;
import org.technologybrewery.fermenter.stout.authz.Action;
import org.technologybrewery.fermenter.stout.authz.PolicyDecision;
import org.technologybrewery.fermenter.stout.authz.PolicyDecisionPoint;
import org.technologybrewery.fermenter.stout.config.StoutBehaviorConfig;

public abstract class AbstractMessageManagerAwareService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageManagerAwareService.class);
    @Inject
    private IdentityManager identityManager;
    protected static StoutBehaviorConfig stoutBehaviorConfig = (StoutBehaviorConfig)KrauseningConfigFactory.create(StoutBehaviorConfig.class, (Map[])new Map[0]);
    protected static boolean shouldCreateMessageOnNonexistentFindByPrimaryKey = stoutBehaviorConfig.shouldCreateErrorOnNonexistentServiceFindByPrimaryKey();
    protected PolicyDecisionPoint pdp = PolicyDecisionPoint.getInstance();

    protected boolean assertAuthorization(String resource, Action action) {
        String currentPrincipalName = this.identityManager.getSubjectName();
        if (currentPrincipalName == null) {
            logger.error("No username available!");
            throw new NotAuthorizedException((Object)"Authorization denied - cannot access user information!", new Object[0]);
        }
        PolicyDecision policyDecision = this.pdp.isAuthorized(currentPrincipalName, resource, action.toString());
        boolean isAuthorized = PolicyDecision.PERMIT.equals((Object)policyDecision);
        if (!isAuthorized) {
            throw new NotAuthorizedException((Object)"Authorization denied!", new Object[0]);
        }
        return isAuthorized;
    }
}

