/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.messages;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.technologybrewery.fermenter.stout.messages.MessageManager;
import org.technologybrewery.fermenter.stout.messages.Messages;
import org.technologybrewery.fermenter.stout.messages.NotSpringManagedDefaultMessages;

@Aspect
@Component
public class MessagesAspect {
    private static Logger logger = LoggerFactory.getLogger(MessagesAspect.class);

    @Pointcut(value="execution(public * *(..))")
    public void publicMethod() {
    }

    @Around(value="execution(* org.technologybrewery.fermenter.stout.messages.MessageManagerAwareService.initializeMessageManager(*)) && args(messages) && publicMethod()")
    public void publicMethodCallingInitializeMessageManager(ProceedingJoinPoint proceedingJoinPoint, Messages messages) {
        boolean isRequestScopeAvailable = this.isRequestScopeAvailable();
        if (isRequestScopeAvailable || !MessageManager.isCreatedLocally()) {
            if (!isRequestScopeAvailable && !MessageManager.isCreatedLocally()) {
                MessageManager.initialize((Messages)new NotSpringManagedDefaultMessages());
                MessageManager.setIsCreatedLocally();
            } else {
                try {
                    proceedingJoinPoint.proceed();
                }
                catch (Throwable t) {
                    logger.error("Could not initialize messages", t);
                }
            }
        }
    }

    @Before(value="execution(* org.technologybrewery.fermenter.stout.messages.MessageManagerAwareService.addAllMessagesToResponse(*)) && publicMethod()")
    public void interceptAddMessagesToResponse(JoinPoint joinPoint) {
        if (!this.isRequestScopeAvailable() && !MessageManager.isCreatedLocally()) {
            MessageManager.initialize((Messages)new NotSpringManagedDefaultMessages());
            MessageManager.setIsCreatedLocally();
        }
    }

    @Before(value="execution(* org.technologybrewery.fermenter.stout.messages.MessageManagerAwareService.addAllMessages(*)) && publicMethod()")
    public void interceptAddMessagesToMessageManager(JoinPoint joinPoint) {
        if (!this.isRequestScopeAvailable() && !MessageManager.isCreatedLocally()) {
            MessageManager.initialize((Messages)new NotSpringManagedDefaultMessages());
            MessageManager.setIsCreatedLocally();
        }
    }

    private boolean isRequestScopeAvailable() {
        return RequestContextHolder.getRequestAttributes() != null;
    }
}

