/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.transaction;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.aeonbits.owner.KrauseningConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.technologybrewery.fermenter.stout.config.StoutTransactionConfig;

@Component
@EnableTransactionManagement
public class TransactionManagerComponent {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManagerComponent.class);

    @Bean
    public JtaTransactionManager transactionManager() {
        this.overrideObjectStoreLocation();
        JtaTransactionManager jtaTxManager = new JtaTransactionManager();
        TransactionManagerImple txManager = new TransactionManagerImple();
        jtaTxManager.setTransactionManager((TransactionManager)txManager);
        javax.transaction.UserTransaction userTransaction = UserTransaction.userTransaction();
        jtaTxManager.setUserTransaction(userTransaction);
        return jtaTxManager;
    }

    protected void overrideObjectStoreLocation() {
        StoutTransactionConfig config = (StoutTransactionConfig)KrauseningConfigFactory.create(StoutTransactionConfig.class, (Map[])new Map[0]);
        String customObjectStorePath = config.getCustomObjectStorePath();
        ObjectStoreEnvironmentBean defaultActionStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class, null);
        defaultActionStoreObjectStoreEnvironmentBean.setObjectStoreDir(customObjectStorePath);
        ObjectStoreEnvironmentBean communicationStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore");
        communicationStoreObjectStoreEnvironmentBean.setObjectStoreDir(customObjectStorePath);
        logger.debug("Set custom object store path to {}", (Object)customObjectStorePath);
    }
}

