/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.aeonbits.owner.KrauseningConfigFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.exception.FermenterException;
import org.technologybrewery.fermenter.stout.exception.UnrecoverableException;
import org.technologybrewery.fermenter.stout.util.DataSourceConfig;
import org.technologybrewery.krausening.Krausening;

public class KrauseningBasedSpringConfig {
    private static final Logger logger = LoggerFactory.getLogger(KrauseningBasedSpringConfig.class);
    protected String jpaPropertiesFileName;
    protected String dataSourcePropertiesFileName;
    protected String dataSourceConfigFullyQualifiedClassName;
    protected static final String DEFAULT_JPA_PROPERTIES = "jpa.properties";
    protected static final String DEFAULT_DATA_SOURCE_PROPERTIES = "data-source.properties";
    protected static final String DEFAULT_DATASOURCE_CONFIG_CLASS = "org.technologybrewery.fermenter.stout.util.DataSourceConfig";

    public KrauseningBasedSpringConfig() {
        this(DEFAULT_JPA_PROPERTIES, DEFAULT_DATA_SOURCE_PROPERTIES, DEFAULT_DATASOURCE_CONFIG_CLASS);
    }

    public KrauseningBasedSpringConfig(String jpaPropertiesFileName, String dataSourcePropertiesFileName, String dataSourceConfigClassName) {
        this.jpaPropertiesFileName = jpaPropertiesFileName;
        this.dataSourcePropertiesFileName = dataSourcePropertiesFileName;
        this.dataSourceConfigFullyQualifiedClassName = dataSourceConfigClassName;
    }

    public DataSource krauseningDataSource() {
        Class<?> dataSourceConfigClass;
        BasicDataSource dataSource = new BasicDataSource();
        Properties dataSourceProps = Krausening.getInstance().getProperties(this.dataSourcePropertiesFileName);
        if (dataSourceProps == null) {
            logger.error("Could not find properties for {}!  You emf bean will not be able to load without these properties! Using defaults instead...", (Object)this.dataSourcePropertiesFileName);
            dataSourceProps = new Properties();
        }
        try {
            dataSourceConfigClass = Class.forName(this.dataSourceConfigFullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new FermenterException("Could not find specific DataSourceConfig class on the classpath!", (Throwable)e);
        }
        DataSourceConfig config = (DataSourceConfig)KrauseningConfigFactory.create(dataSourceConfigClass, (Map[])new Map[]{System.getProperties()});
        String interleavedUrl = config.getUrl();
        if (interleavedUrl != null) {
            dataSourceProps.put("url", interleavedUrl);
        }
        for (String propName : dataSourceProps.stringPropertyNames()) {
            try {
                BeanUtils.setProperty((Object)dataSource, (String)propName, (Object)dataSourceProps.getProperty(propName));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnrecoverableException("Could not set data source property [" + propName + "] to value [" + dataSourceProps.getProperty(propName) + "]");
            }
        }
        return dataSource;
    }

    public Properties krauseningJpaProperties() {
        return Krausening.getInstance().getProperties(this.jpaPropertiesFileName);
    }
}

