/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.stout.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.stout.exception.FermenterException;
import org.technologybrewery.fermenter.stout.exception.UnrecoverableException;

public final class MetamodelInstanceUtil {
    public static final Logger logger = LoggerFactory.getLogger(MetamodelInstanceUtil.class);

    private MetamodelInstanceUtil() {
    }

    public static void checkTableNameForMismatch(String className, String expectedTableName) {
        boolean isMismatched = false;
        try {
            Class<?> boTarget = Class.forName(className);
            Method method = Class.class.getDeclaredMethod("annotationData", new Class[0]);
            method.setAccessible(true);
            Object annotationData = method.invoke(boTarget, new Object[0]);
            Field annotations = annotationData.getClass().getDeclaredField("annotations");
            annotations.setAccessible(true);
            Map map = (Map)annotations.get(annotationData);
            Table tableAnnotation = (Table)map.get(Table.class);
            String foundTableName = tableAnnotation.name();
            if (!expectedTableName.equalsIgnoreCase(foundTableName)) {
                isMismatched = true;
                logger.error("Mismatching table names encountered for {}!\n\t table name found: {},\n\t table name expected: {}", new Object[]{className, foundTableName, expectedTableName});
            }
        }
        catch (Exception e) {
            throw new FermenterException("Exception encountered validating " + className + " against metamodel instances!", (Throwable)e);
        }
        if (isMismatched) {
            logger.error("To fix this, ensure {}'s @Table annotation matches your metamodel instance!", (Object)className);
            throw new UnrecoverableException("Mimatching table names for " + className + " and its entity file!");
        }
    }
}

