/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.mash.jolt;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.mash.MediationException;
import org.technologybrewery.mash.Mediator;

public class JoltMediator
extends Mediator {
    private static final Logger logger = LoggerFactory.getLogger(JoltMediator.class);
    public static final String JOLT_MEDIATION_SPECIFICATION = "jolt-specification";

    protected Object performMediation(Object input, Properties properties) {
        Object output = null;
        if (input != null) {
            Chainr chainr = this.getExecutableJoltTransformSchema(properties);
            output = chainr.transform(input);
        }
        return output;
    }

    protected String performMediation(String input, Properties properties) {
        String output = null;
        if (input != null) {
            Chainr chainr = this.getExecutableJoltTransformSchema(properties);
            Object result = chainr.transform(JsonUtils.jsonToObject((String)input));
            output = JsonUtils.toJsonString((Object)result);
        }
        return output;
    }

    private Chainr getExecutableJoltTransformSchema(Properties properties) {
        String joltSpecification = properties.getProperty(JOLT_MEDIATION_SPECIFICATION);
        if (StringUtils.isBlank((CharSequence)joltSpecification)) {
            throw new MediationException("jolt-specification was not specified!");
        }
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(joltSpecification);
        String decodedPath = null;
        try {
            decodedPath = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        logger.debug("Using jolt specification: {}", (Object)decodedPath);
        List specAsJson = JsonUtils.filepathToList((String)decodedPath);
        Chainr chainr = Chainr.fromSpec((Object)specAsJson);
        return chainr;
    }
}

