/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.mash.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.technologybrewery.mash.MediationException;
import org.technologybrewery.mash.Mediator;

public class VelocityMediator
extends Mediator {
    public static final String VELOCITY_MEDIATION_TEMPLATE = "velocity-template";
    public static final String VELOCITY_INPUT_CLASS = "velocity-input-class";
    public static final String INPUT = "input";
    private String templatePath;

    public VelocityMediator() {
        Properties props = new Properties();
        String className = ClasspathResourceLoader.class.getName();
        props.setProperty("classpath.resource.loader.class", className);
        props.setProperty("resource.loader", "classpath");
        Velocity.init((Properties)props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performMediation(Object input, Properties properties) {
        String output = null;
        if (input != null) {
            StringWriter writer = null;
            try {
                this.validateInputClass(input, properties);
                this.templatePath = properties.getProperty(VELOCITY_MEDIATION_TEMPLATE);
                Template template = this.getTemplate();
                VelocityContext context = this.getContext();
                context.put(INPUT, input);
                writer = new StringWriter();
                template.merge((Context)context, (Writer)writer);
                output = writer.toString();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        return output;
    }

    protected Template getTemplate() {
        if (StringUtils.isBlank((CharSequence)this.templatePath)) {
            throw new MediationException("velocity-template was not specified!");
        }
        Template template = Velocity.getTemplate((String)this.templatePath);
        if (template == null) {
            throw new MediationException("Template '" + this.templatePath + "' could not be found!");
        }
        return template;
    }

    protected void validateInputClass(Object input, Properties properties) {
        Class<?> expectedInputClass;
        String className = properties.getProperty(VELOCITY_INPUT_CLASS, Object.class.getName());
        try {
            expectedInputClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new MediationException("Could not find mediator input class type!", (Throwable)e);
        }
        if (!expectedInputClass.isInstance(input)) {
            throw new MediationException("Input (" + input.getClass().getName() + ") is not an instance of " + expectedInputClass.getName() + "!");
        }
    }

    protected VelocityContext getContext() {
        return new VelocityContext();
    }
}

