/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.mojo;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.technologybrewery.orphedomos.mojo.AbstractDockerMojo;
import org.technologybrewery.orphedomos.util.exec.DockerCommandExecutor;
import org.technologybrewery.orphedomos.util.exec.DockerCredentialExecutor;

@Mojo(name="multiplatform-build-deploy")
public class DockerBuildMultiPlatformMojo
extends AbstractDockerMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.isOrphedomosModule()) {
            return;
        }
        DockerCredentialExecutor credentials = new DockerCredentialExecutor(this.settings, this.repoId, this.repoUrl, this.dockerContext, this.usePlainTextPassword, this.dryRun);
        credentials.login();
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        ArrayList<String> executionArgs = new ArrayList<String>(Arrays.asList("buildx", "build", "--tag", this.getImageTag(), "--push", "--file", this.getDockerfilePath()));
        if (this.targetArchitectures.length > 0) {
            executionArgs.add("--platform");
            executionArgs.add(String.join((CharSequence)",", this.targetArchitectures));
        }
        executionArgs.addAll(this.getBuildArgumentsList());
        if (this.buildOptions.size() > 0) {
            executionArgs.addAll(this.buildOptions);
        }
        executionArgs.add(this.dockerContext.getAbsolutePath());
        executor.executeAndLogOutput(executionArgs);
        credentials.logout();
    }
}

