/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.util.exec;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Settings;
import org.technologybrewery.orphedomos.util.OrphedomosException;
import org.technologybrewery.orphedomos.util.credential.CredentialUtil;
import org.technologybrewery.orphedomos.util.exec.DockerCommandExecutor;

public class DockerCredentialExecutor {
    private Settings settings;
    private String repoId;
    private String repoUrl;
    private File dockerContext;
    private boolean usePlainTextPassword;
    private boolean dryRun;

    public DockerCredentialExecutor(Settings settings, String repoId, String repoUrl, File dockerContext, boolean usePlainTextPassword, boolean dryRun) {
        this.settings = settings;
        this.repoId = repoId;
        this.repoUrl = repoUrl;
        this.dockerContext = dockerContext;
        this.usePlainTextPassword = usePlainTextPassword;
        this.dryRun = dryRun;
    }

    private void validateLoginDefined(String username, String password) throws OrphedomosException {
        if (username == null || password == null) {
            throw new OrphedomosException("Missing or invalid credentials for repository id " + this.repoId + ".  Please validate your Maven settings.xml!");
        }
    }

    public void login() throws MojoExecutionException {
        if (this.dryRun) {
            return;
        }
        String username = CredentialUtil.findUsernameForServer(this.settings, this.repoId);
        String password = this.findPasswordForServer(this.repoId);
        this.validateLoginDefined(username, password);
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        executor.executeWithSensitiveArgsAndLogOutput(Arrays.asList(new ImmutablePair((Object)"login", (Object)false), new ImmutablePair((Object)"--username", (Object)false), new ImmutablePair((Object)username, (Object)false), new ImmutablePair((Object)"--password", (Object)false), new ImmutablePair((Object)password, (Object)true), new ImmutablePair((Object)this.repoUrl, (Object)false)));
    }

    private String findPasswordForServer(String serverId) throws MojoExecutionException {
        if (this.dryRun) {
            return "";
        }
        String password = this.usePlainTextPassword ? CredentialUtil.findPlaintextPasswordForServer(this.settings, serverId) : CredentialUtil.decryptServerPassword(this.settings, serverId);
        return password;
    }

    public void logout() throws MojoExecutionException {
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        executor.executeAndLogOutput(Arrays.asList("logout"));
    }
}

