/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;
import org.technologybrewery.orphedomos.util.credential.CredentialUtil;
import org.technologybrewery.orphedomos.util.exec.DockerCommandExecutor;

public abstract class AbstractDockerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", property="orphedomos.docker.context")
    protected File dockerContext;
    @Parameter(defaultValue="false", property="orphedomos.build.dryrun")
    protected boolean dryRun;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Parameter(defaultValue="${project.packaging}")
    private String packaging;
    @Parameter(defaultValue="${project.artifactId}", property="orphedomos.image.name")
    protected String imageName;
    @Parameter(defaultValue="${project.version}", property="orphedomos.image.version")
    protected String imageVersion;
    @Parameter(property="orphedomos.image.aliases")
    protected String[] aliases;
    @Parameter(defaultValue="false", property="orphedomos.credential.usePlainTextPassword")
    protected boolean usePlainTextPassword;
    @Parameter(defaultValue="", property="orphedomos.repository.id")
    protected String repoId;
    @Parameter(defaultValue="", property="orphedomos.repository.url")
    protected String repoUrl;
    @Parameter(defaultValue="true", property="orphedomos.buildkit.enable")
    protected boolean useBuildKit;
    @Parameter(defaultValue="/src/main/resources/docker/Dockerfile", property="orphedomos.dockerfile.path")
    protected String dockerfilePath;
    @Parameter(property="orphedomos.build.architecture")
    protected String[] targetArchitectures;
    @Parameter(property="orphedomos.build.args")
    protected Map<String, String> buildArgs;
    @Parameter(defaultValue="false", property="orphedomos.skip")
    private boolean skip;
    @Parameter(defaultValue="", property="orphedomos.image.tagsuffix")
    private String tagSuffix;

    protected String getImageTag() {
        return this.imageName + ":" + this.imageVersion + (this.tagSuffix == null ? "" : this.tagSuffix);
    }

    protected String getImageTagWithArch(String arch) {
        return this.getImageTag() + "-" + arch;
    }

    protected boolean isOrphedomosModule() {
        return this.packaging.equalsIgnoreCase("orphedomos");
    }

    protected String getDockerfilePath() {
        return this.dockerContext.getPath() + (this.dockerContext.getPath().endsWith(File.separator) ? "" : File.separator) + this.dockerfilePath;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of all orphedomos-maven-plugin goals as 'skip' is set to true");
        } else {
            this.doExecute();
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected List<String> getArgumentsList() {
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<String, String> kv : this.buildArgs.entrySet()) {
            args.add("--build-arg");
            args.add(kv.getKey() + "=" + kv.getValue());
        }
        return args;
    }

    protected void login() throws MojoExecutionException {
        if (this.dryRun) {
            return;
        }
        String password = this.findPasswordForServer(this.repoId);
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        executor.executeWithSensitiveArgsAndLogOutput(Arrays.asList(new ImmutablePair((Object)"login", (Object)false), new ImmutablePair((Object)"--username", (Object)false), new ImmutablePair((Object)CredentialUtil.findUsernameForServer(this.settings, this.repoId), (Object)false), new ImmutablePair((Object)"--password", (Object)false), new ImmutablePair((Object)password, (Object)true), new ImmutablePair((Object)this.repoUrl, (Object)false)));
    }

    protected void logout() throws MojoExecutionException {
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        executor.executeAndLogOutput(Arrays.asList("logout"));
    }

    protected String prependRegistry(String suffix) {
        return this.repoUrl + (this.repoUrl.endsWith("/") ? "" : "/") + suffix;
    }

    protected String findPasswordForServer(String serverId) throws MojoExecutionException {
        if (this.dryRun) {
            return "";
        }
        String password = this.usePlainTextPassword ? CredentialUtil.findPlaintextPasswordForServer(this.settings, serverId) : CredentialUtil.decryptServerPassword(this.settings, serverId);
        return password;
    }
}

