/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.mojo;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.orphedomos.mojo.AbstractDockerMojo;
import org.technologybrewery.orphedomos.util.exec.DockerCommandExecutor;

@Mojo(name="build-docker-image", defaultPhase=LifecyclePhase.PACKAGE)
public class DockerBuildMojo
extends AbstractDockerMojo {
    private static final Logger logger = LoggerFactory.getLogger(DockerBuildMojo.class);

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.repoId != null && !this.repoId.isBlank()) {
            this.login();
        }
        logger.info("Built docker image...");
        logger.info("Current directory: " + this.dockerContext);
        if (this.useBuildKit) {
            this.buildWithBuildKit();
        } else {
            this.buildLegacy();
        }
        this.applyAliases();
        if (this.repoId != null && !this.repoId.isBlank()) {
            this.logout();
        }
    }

    private void applyAliases() throws MojoExecutionException {
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        for (String alias : this.aliases) {
            executor.executeAndLogOutput(Arrays.asList("tag", this.getImageTag(), alias));
        }
    }

    private void buildWithBuildKit() throws MojoExecutionException {
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        ArrayList<String> executionArgs = new ArrayList<String>(Arrays.asList("buildx", "build", "--tag", this.getImageTag(), "--load", "--file", this.getDockerfilePath()));
        executionArgs.addAll(this.getArgumentsList());
        executionArgs.add(this.dockerContext.getAbsolutePath());
        executor.executeAndLogOutput(executionArgs);
    }

    private void buildLegacy() throws MojoExecutionException {
        logger.warn("Building image without BuildKit.  Please consider using BuildKit for enhanced performance!");
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        ArrayList<String> executionArgs = new ArrayList<String>(Arrays.asList("build", "-t", this.getImageTag(), "--file", this.getDockerfilePath()));
        executionArgs.addAll(this.getArgumentsList());
        executionArgs.add(this.dockerContext.getAbsolutePath());
        if (this.targetArchitectures.length == 0) {
            executor.executeAndLogOutput(executionArgs);
        }
    }
}

