/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.orphedomos.mojo;

import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.orphedomos.mojo.AbstractDockerMojo;
import org.technologybrewery.orphedomos.util.exec.DockerCommandExecutor;

@Mojo(name="push-docker-image", defaultPhase=LifecyclePhase.DEPLOY)
public class DockerDeployMojo
extends AbstractDockerMojo {
    private static final Logger logger = LoggerFactory.getLogger(DockerDeployMojo.class);

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.login();
        DockerCommandExecutor executor = new DockerCommandExecutor(this.dockerContext);
        if (this.targetArchitectures.length == 0) {
            String newName = this.prependRegistry(this.getImageTag());
            executor.executeAndLogOutput(Arrays.asList("tag", this.getImageTag(), newName));
            if (!this.dryRun) {
                executor.executeAndLogOutput(Arrays.asList("push", newName));
            }
            for (String alias : this.aliases) {
                executor.executeAndLogOutput(Arrays.asList("tag", this.getImageTag(), alias));
                executor.executeAndLogOutput(Arrays.asList("push", alias));
            }
        }
        this.logout();
    }
}

